/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.data;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Ref;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.registration.Side;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.tool.MaterialSword;
import muramasa.antimatter.tool.armor.AntimatterArmorType;
import muramasa.antimatter.tool.behaviour.BehaviourAOEBreak;
import muramasa.antimatter.tool.behaviour.BehaviourBlockTilling;
import muramasa.antimatter.tool.behaviour.BehaviourExtendedHighlight;
import muramasa.antimatter.tool.behaviour.BehaviourLogStripping;
import muramasa.antimatter.tool.behaviour.BehaviourPoweredDebug;
import muramasa.antimatter.tool.behaviour.BehaviourPumpkinCarving;
import muramasa.antimatter.tool.behaviour.BehaviourTorchPlacing;
import muramasa.antimatter.tool.behaviour.BehaviourTreeFelling;
import muramasa.antimatter.tool.behaviour.BehaviourVanillaShovel;
import muramasa.antimatter.tool.behaviour.BehaviourWaterlogToggle;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class AntimatterDefaultTools {
    public static final AntimatterToolType SWORD = new AntimatterToolType("antimatter", "sword", 2, 1, 10, 3.0f, -2.4f, false).setToolClass(MaterialSword.class).addEffectiveBlocks(Blocks.f_50033_).setHasContainer(false);
    public static final AntimatterToolType PICKAXE = new AntimatterToolType("antimatter", "pickaxe", 1, 2, 10, 1.0f, -2.8f, true).addEffectiveMaterials(Material.f_76316_, Material.f_76283_).setHasContainer(false);
    public static final AntimatterToolType DRILL = new AntimatterToolType("antimatter", "drill", 2, 2, 10, 3.0f, -3.0f, false).setType(PICKAXE).setUseAction(UseAnim.BLOCK).setPowered(100000L, 1, 2, 3).setUseSound(Ref.DRILL).addTags("pickaxe", "shovel").addEffectiveMaterials(Material.f_76316_, Material.f_76283_, Material.f_76314_, Material.f_76313_, Material.f_76315_, Material.f_76317_).setRepairability(false);
    public static final AntimatterToolType SHOVEL = new AntimatterToolType("antimatter", "shovel", 1, 2, 10, 1.5f, -3.0f, true).addEffectiveMaterials(Material.f_76313_, Material.f_76317_, Material.f_76308_, Material.f_76280_, Material.f_76314_).setHasContainer(false);
    public static final AntimatterToolType AXE = new AntimatterToolType("antimatter", "axe", 1, 1, 10, 6.0f, -3.0f, true).addEffectiveMaterials(Material.f_76300_, Material.f_76302_, Material.f_76271_).setHasContainer(false);
    public static final AntimatterToolType HOE = new AntimatterToolType("antimatter", "hoe", 1, 2, 10, -2.0f, -1.0f, true).setHasContainer(false);
    public static final AntimatterToolType HAMMER = new AntimatterToolType("antimatter", "hammer", 1, 2, 2, 3.0f, -3.0f, false).addTags("pickaxe").addEffectiveMaterials(Material.f_76279_, Material.f_76278_).setUseSound(SoundEvents.f_11669_).setRepairability(false);
    public static final AntimatterToolType WRENCH = new AntimatterToolType("antimatter", "wrench", 2, 2, 2, 1.5f, -2.8f, false).setUseSound(Ref.WRENCH).setOverlayLayers(0).setRepairability(false);
    public static final AntimatterToolType ELECTRIC_WRENCH = new AntimatterToolType("antimatter", "electric_wrench", WRENCH).setTag(WRENCH).setPowered(100000L, 1, 2, 3).setUseSound(Ref.WRENCH).addTags("wrench");
    public static final AntimatterToolType SAW = new AntimatterToolType("antimatter", "saw", 2, 2, 2, 2.0f, -2.8f, false).addEffectiveBlocks(Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50568_).setRepairability(false);
    public static final AntimatterToolType BUZZSAW = new AntimatterToolType("antimatter", "buzzsaw", 2, 2, 2, 0.5f, -2.7f, false).setTag(SAW).setPowered(100000L, 1, 2, 3).setOverlayLayers(2).addTags("saw");
    public static final AntimatterToolType FILE = new AntimatterToolType("antimatter", "file", 2, 2, 2, -2.0f, -2.4f, false).setRepairability(false);
    public static final AntimatterToolType CROWBAR = new AntimatterToolType("antimatter", "crowbar", 2, 10, 5, 1.0f, -2.0f, false).setUseSound(SoundEvents.f_12018_).setSecondaryRequirement(MaterialTags.RUBBERTOOLS).setRepairability(false);
    public static final AntimatterToolType SOFT_HAMMER = new AntimatterToolType("antimatter", "soft_hammer", 2, 2, 2, 1.0f, -3.0f, false).setRepairability(false);
    public static final AntimatterToolType SCREWDRIVER = new AntimatterToolType("antimatter", "screwdriver", 2, 2, 2, 0.0f, -1.0f, false).setUseSound(Ref.WRENCH).setRepairability(false);
    public static final AntimatterToolType ELECTRIC_SCREWDRIVER = new AntimatterToolType("antimatter", "electric_screwdriver", SCREWDRIVER).setTag(SCREWDRIVER).setPowered(100000L, 1, 2, 3).setUseSound(Ref.WRENCH).setOverlayLayers(2);
    public static final AntimatterToolType MORTAR = new AntimatterToolType("antimatter", "mortar", 5, 5, 2, -2.0f, 0.0f, false).setUseSound(SoundEvents.f_11998_).setBlockBreakability(false).setRepairability(false);
    public static final AntimatterToolType WIRE_CUTTER = new AntimatterToolType("antimatter", "wire_cutter", 5, 3, 2, 0.0f, -1.5f, false).setUseSound(SoundEvents.f_12344_).addEffectiveMaterials(Material.f_76272_, Material.f_76318_, Material.f_76311_, Material.f_76299_).setRepairability(false);
    public static final AntimatterToolType BRANCH_CUTTER = new AntimatterToolType("antimatter", "branch_cutter", 1, 3, 2, 0.0f, -1.5f, false).addTags("grafter").addEffectiveMaterials(Material.f_76274_).setHasContainer(false);
    public static final AntimatterToolType KNIFE = new AntimatterToolType("antimatter", "knife", 2, 2, 5, 2.1f, -2.0f, false).setToolClass(MaterialSword.class).addEffectiveBlocks(Blocks.f_50033_).setRepairability(false);
    public static final AntimatterToolType PLUNGER = new AntimatterToolType("antimatter", "plunger", 5, 5, 10, 0.0f, -2.9f, false).setUseSound(SoundEvents.f_11778_).setPrimaryRequirement(MaterialTags.RUBBERTOOLS).setRepairability(false);
    public static final AntimatterToolType CHAINSAW = new AntimatterToolType("antimatter", "chainsaw", 2, 1, 5, 3.0f, -2.0f, false).setUseAction(UseAnim.BLOCK).setPowered(100000L, 1, 2, 3).addEffectiveMaterials(Material.f_76320_, Material.f_76300_, Material.f_76302_, Material.f_76271_, Material.f_76274_).addTags("axe", "saw");
    public static final AntimatterToolType JACKHAMMER = new AntimatterToolType("antimatter", "jackhammer", 2, 2, 10, 1.0f, -3.2f, false).setPowered(100000L, 1, 2, 3).setUseSound(Ref.DRILL).addEffectiveMaterials(Material.f_76278_, Material.f_76314_, Material.f_76317_, Material.f_76315_);
    public static final AntimatterArmorType HELMET = new AntimatterArmorType("antimatter", "helmet", 40, 0, 0.0f, 0.0f, EquipmentSlot.HEAD);
    public static final AntimatterArmorType CHESTPLATE = new AntimatterArmorType("antimatter", "chestplate", 40, 0, 0.0f, 0.0f, EquipmentSlot.CHEST);
    public static final AntimatterArmorType LEGGINGS = new AntimatterArmorType("antimatter", "leggings", 40, 0, 0.0f, 0.0f, EquipmentSlot.LEGS);
    public static final AntimatterArmorType BOOTS = new AntimatterArmorType("antimatter", "boots", 40, 0, 0.0f, 0.0f, EquipmentSlot.FEET);

    public static void init(Side side) {
        for (AntimatterToolType type : AntimatterAPI.all(AntimatterToolType.class)) {
            if (type.getActualTags().contains(BlockTags.f_144283_)) {
                type.addBehaviour(BehaviourVanillaShovel.INSTANCE);
            }
            if (type.getActualTags().contains(BlockTags.f_144281_)) {
                type.addBehaviour(BehaviourBlockTilling.INSTANCE);
            }
            if (!type.isPowered()) continue;
            type.addBehaviour(BehaviourPoweredDebug.INSTANCE);
        }
        AXE.addBehaviour(BehaviourLogStripping.INSTANCE, BehaviourTreeFelling.INSTANCE);
        PICKAXE.addBehaviour(BehaviourTorchPlacing.INSTANCE);
        CHAINSAW.addBehaviour(BehaviourTreeFelling.INSTANCE, BehaviourLogStripping.INSTANCE);
        DRILL.addBehaviour(new BehaviourAOEBreak(1, 1, 1, "3x3"), BehaviourTorchPlacing.INSTANCE);
        JACKHAMMER.addBehaviour(new BehaviourAOEBreak(1, 0, 2, "1x0x2"));
        PLUNGER.addBehaviour(BehaviourWaterlogToggle.INSTANCE);
        KNIFE.addBehaviour(BehaviourPumpkinCarving.INSTANCE);
        if (side == Side.CLIENT) {
            AntimatterDefaultTools.clientInit();
        }
    }

    private static void clientInit() {
        WRENCH.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe && b.m_204297_().m_203656_(WRENCH.getToolType()) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61373_), BehaviourExtendedHighlight.PIPE_FUNCTION));
        SCREWDRIVER.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe, BehaviourExtendedHighlight.COVER_FUNCTION));
        ELECTRIC_WRENCH.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe && b.m_204297_().m_203656_(WRENCH.getToolType()), BehaviourExtendedHighlight.PIPE_FUNCTION));
        WIRE_CUTTER.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockPipe && b.m_204297_().m_203656_(WIRE_CUTTER.getToolType()), BehaviourExtendedHighlight.PIPE_FUNCTION));
        CROWBAR.addBehaviour(new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe, BehaviourExtendedHighlight.COVER_FUNCTION));
    }
}

