/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.cover;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.client.dynamic.IDynamicModelProvider;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.gui.GuiData;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.network.packets.AbstractGuiEventPacket;
import muramasa.antimatter.registration.ITextureProvider;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public interface ICover
extends ITextureProvider,
IDynamicModelProvider,
MenuProvider,
IGuiHandler {
    public static final ResourceLocation PIPE_COVER_MODEL = new ResourceLocation("antimatter", "block/cover/cover_pipe");
    public static final ICover empty = new ICover(){

        @Override
        public Direction side() {
            return null;
        }

        @Override
        public CoverFactory getFactory() {
            return emptyFactory;
        }

        @Override
        public Tier getTier() {
            return null;
        }

        @Override
        public void deserialize(CompoundTag nbt) {
        }

        @Override
        public CompoundTag serialize() {
            return new CompoundTag();
        }

        @Override
        public ItemStack getItem() {
            return ItemStack.f_41583_;
        }

        @Override
        public ICoverHandler<?> source() {
            return null;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public ResourceLocation getGuiTexture() {
            return null;
        }

        @Override
        public AbstractGuiEventPacket createGuiPacket(IGuiEvent event) {
            return null;
        }

        @Override
        public ResourceLocation getModel(String type, Direction dir) {
            return null;
        }

        @Override
        public Texture[] getTextures() {
            return new Texture[0];
        }

        @Override
        public void setTextures(BiConsumer<String, Texture> texer) {
        }

        @Override
        public boolean ticks() {
            return false;
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
            return null;
        }
    };
    public static final CoverFactory emptyFactory = CoverFactory.builder((a, b, c, d) -> empty).build("antimatter", "none");

    default public void onPlace() {
    }

    @Nonnull
    default public Component m_5446_() {
        return new TextComponent(Utils.underscoreToUpperCamel(this.getId()));
    }

    @Override
    default public void onGuiEvent(IGuiEvent event, Player player) {
    }

    default public void onTransfer(Object object, boolean inputSide, boolean simulate) {
    }

    public Direction side();

    @Override
    default public ResourceLocation getLoc() {
        return new ResourceLocation(this.getDomain(), this.getId());
    }

    @Override
    default public String getId() {
        return this.getFactory().getId();
    }

    @Override
    default public String getDomain() {
        return this.getFactory().getDomain();
    }

    public CoverFactory getFactory();

    public Tier getTier();

    default public void onRemove() {
    }

    default public void onUpdate() {
    }

    default public void onBlockUpdate() {
    }

    @Override
    default public String handlerDomain() {
        return this.getDomain();
    }

    default public void onMachineEvent(TileEntityMachine<?> tile, IMachineEvent event, int ... data) {
    }

    default public boolean hasGui() {
        return false;
    }

    default public boolean openGui(Player player, Direction side) {
        if (!this.hasGui()) {
            return false;
        }
        AntimatterPlatformUtils.openGui((ServerPlayer)player, this, packetBuffer -> {
            packetBuffer.m_130064_(this.source().getTile().m_58899_());
            packetBuffer.writeInt(side.m_122411_());
        });
        player.m_6330_(Ref.WRENCH, SoundSource.BLOCKS, 1.0f, 2.0f);
        return true;
    }

    default public int getWeakPower() {
        return 0;
    }

    default public int getStrongPower() {
        return 0;
    }

    default public int getPriority(Class<?> clazz) {
        return 0;
    }

    default public boolean onInteract(Player player, InteractionHand hand, Direction side, @Nullable AntimatterToolType type) {
        return false;
    }

    default public boolean ticks() {
        return true;
    }

    public void deserialize(CompoundTag var1);

    public CompoundTag serialize();

    public ItemStack getItem();

    default public <T> boolean blocksCapability(Class<T> cap, @Nullable Direction side) {
        return false;
    }

    default public <T> boolean blocksInput(Class<T> cap, @Nullable Direction side) {
        return false;
    }

    default public <T> boolean blocksOutput(Class<T> cap, @Nullable Direction side) {
        return false;
    }

    public void setTextures(BiConsumer<String, Texture> var1);

    default public ItemStack getDroppedStack() {
        return this.getItem();
    }

    default public boolean isEqual(ICover cover) {
        return this.getLoc().equals((Object)cover.getLoc());
    }

    default public boolean isEqual(CoverFactory fac) {
        return this.getLoc().equals((Object)new ResourceLocation(fac.domain, fac.getId()));
    }

    public ICoverHandler<?> source();

    default public GuiData getGui() {
        return null;
    }

    default public List<BakedQuad> transformQuads(BlockState state, List<BakedQuad> quads) {
        return quads;
    }

    default public boolean isEmpty() {
        return this == empty;
    }

    public static void init() {
    }

    public static class DynamicKey {
        public final Direction facing;
        public final Texture machineTexture;
        public final String coverId;

        public DynamicKey(Direction facing, Texture tex, String cover) {
            this.facing = facing;
            this.machineTexture = tex;
            this.coverId = cover;
        }

        public DynamicKey(BlockState state, Texture tex, String cover) {
            this.facing = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            this.machineTexture = tex;
            this.coverId = cover;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.facing, this.machineTexture, this.coverId});
        }

        public boolean equals(Object o) {
            if (o instanceof DynamicKey) {
                DynamicKey k = (DynamicKey)o;
                return k.facing == this.facing && k.machineTexture.equals((Object)this.machineTexture) && this.coverId.equals(k.coverId);
            }
            return false;
        }
    }
}

