/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.cover;

import java.util.List;
import java.util.function.BiConsumer;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.client.RenderHelper;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.CoverMaterial;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.texture.Texture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class CoverPlate
extends CoverMaterial {
    private final MaterialType<?> type;
    private final Material material;

    public CoverPlate(ICoverHandler<?> source, Tier tier, Direction side, CoverFactory factory, MaterialType<?> type, Material material) {
        super(source, tier, side, factory);
        this.type = type;
        this.material = material;
    }

    @Override
    public boolean ticks() {
        return false;
    }

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return new ResourceLocation("antimatter:block/cover/cover_pipe_notint");
        }
        return new ResourceLocation("antimatter:block/cover/basic_notint");
    }

    @Override
    public MaterialType<?> getType() {
        return this.type;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public ItemStack getDroppedStack() {
        return AntimatterMaterialTypes.PLATE.get(this.material, 1);
    }

    @Override
    public void setTextures(BiConsumer<String, Texture> texer) {
        Texture[] tex = this.material.getSet().getTextures(AntimatterMaterialTypes.BLOCK);
        texer.accept("overlay", tex[0]);
    }

    @Override
    public List<BakedQuad> transformQuads(BlockState state, List<BakedQuad> quads) {
        quads.forEach(t -> RenderHelper.colorQuad(t, this.material.getRGB()));
        return quads;
    }

    @Override
    public Texture[] getTextures() {
        return new Texture[]{this.material.getSet().getTextures(AntimatterMaterialTypes.BLOCK)[0]};
    }
}

