/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.cover;

import javax.annotation.Nullable;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.CoverInput;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.event.MachineEvent;
import muramasa.antimatter.tile.TileEntityFakeBlock;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.FluidPlatformUtils;
import tesseract.TesseractCapUtils;
import tesseract.TesseractGraphWrappers;

public class CoverOutput
extends CoverInput {
    private boolean ejectItems = false;
    private boolean ejectFluids = false;

    public CoverOutput(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        if (source.getTile() instanceof TileEntityFakeBlock) {
            this.setEjects(true, true);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        if (this.handler.getTile().m_58904_().m_46467_() % 100L == 0L) {
            if (this.shouldOutputFluids()) {
                this.processFluidOutput();
            }
            if (this.shouldOutputItems()) {
                this.processItemOutput();
            }
        }
    }

    @Override
    public void onRemove() {
        super.onRemove();
    }

    public void manualOutput() {
        if (this.shouldOutputFluids()) {
            this.processFluidOutput();
        }
        if (this.shouldOutputItems()) {
            this.processItemOutput();
        }
    }

    public boolean shouldOutputItems() {
        return this.ejectItems;
    }

    public boolean shouldOutputFluids() {
        return this.ejectFluids;
    }

    public void setEjects(boolean fluid, boolean item) {
        this.ejectItems = item;
        this.ejectFluids = fluid;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.ejectItems = nbt.m_128471_("ei");
        this.ejectFluids = nbt.m_128471_("ef");
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128379_("ei", this.ejectItems);
        nbt.m_128379_("ef", this.ejectFluids);
        return nbt;
    }

    protected void processItemOutput() {
        BlockEntity adjTile = Utils.getTile((BlockGetter)this.handler.getTile().m_58904_(), this.handler.getTile().m_58899_().m_142300_(this.side));
        if (adjTile == null) {
            return;
        }
        TesseractCapUtils.getItemHandler((BlockEntity)adjTile, (Direction)this.side.m_122424_()).ifPresent(adjHandler -> TesseractCapUtils.getItemHandler(this.handler.getTile(), (Direction)this.side).ifPresent(h -> Utils.transferItems(h, adjHandler, false)));
    }

    protected void processFluidOutput() {
        BlockEntity adjTile = Utils.getTile((BlockGetter)this.handler.getTile().m_58904_(), this.handler.getTile().m_58899_().m_142300_(this.side));
        if (adjTile == null) {
            return;
        }
        TesseractCapUtils.getFluidHandler((BlockEntity)adjTile, (Direction)this.side.m_122424_()).ifPresent(adjHandler -> TesseractCapUtils.getFluidHandler(this.handler.getTile(), (Direction)this.side).ifPresent(h -> FluidPlatformUtils.tryFluidTransfer((IFluidHandler)adjHandler, (IFluidHandler)h, (long)(1000L * TesseractGraphWrappers.dropletMultiplier), (boolean)true)));
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player player) {
        if (event.getFactory() == GuiEvents.ITEM_EJECT) {
            this.ejectItems = !this.ejectItems;
            this.processItemOutput();
            Utils.markTileForNBTSync(this.handler.getTile());
        }
        if (event.getFactory() == GuiEvents.FLUID_EJECT) {
            this.ejectFluids = !this.ejectFluids;
            this.processFluidOutput();
            Utils.markTileForNBTSync(this.handler.getTile());
        }
    }

    @Override
    public void onMachineEvent(TileEntityMachine<?> tile, IMachineEvent event, int ... data) {
        if (event == MachineEvent.ITEMS_OUTPUTTED && this.ejectItems) {
            this.processItemOutput();
        } else if (event == MachineEvent.FLUIDS_OUTPUTTED && this.ejectFluids) {
            this.processFluidOutput();
        }
    }
}

