/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.cover;

import java.util.Random;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.BaseCover;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.structure.StructureCache;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class CoverMuffler
extends BaseCover {
    public CoverMuffler(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverMuffler.getBasicModel();
    }

    @Override
    public boolean ticks() {
        return true;
    }

    @Override
    public void onUpdate() {
        BlockPos pos = this.handler.getTile().m_58899_();
        Level world = this.handler.getTile().m_58904_();
        if (world.f_46443_) {
            TileEntityMultiMachine tile = StructureCache.getAnyMulti(world, pos, TileEntityMultiMachine.class);
            if (tile == null || tile.getMachineState() != MachineState.ACTIVE) {
                return;
            }
            Random rand = world.f_46441_;
            Direction dir = this.side;
            double d0 = (double)pos.m_123341_() + 0.5 + (dir.m_122434_() == Direction.Axis.X ? 0.0 : (rand.nextDouble() - 0.5) / 2.0);
            double d1 = (double)pos.m_123342_() + 0.5 + (dir.m_122434_() == Direction.Axis.Y ? 0.0 : (rand.nextDouble() - 0.5) / 2.0);
            double d2 = (double)pos.m_123343_() + 0.5 + (dir.m_122434_() == Direction.Axis.Z ? 0.0 : (rand.nextDouble() - 0.5) / 2.0);
            if (rand.nextDouble() < 0.1) {
                // empty if block
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + (double)(0.6f * (float)this.side.m_122429_()), d1 + 0.6 * (double)this.side.m_122430_(), d2 + (double)(0.6f * (float)this.side.m_122431_()), (double)this.side.m_122429_(), (double)this.side.m_122430_(), (double)this.side.m_122431_());
        }
    }
}

