/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.cover;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.Data;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.gui.MenuHandler;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.texture.Texture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CoverFactory
implements IAntimatterObject {
    final String id;
    final String domain;
    private final CoverSupplier supplier;
    private Map<Tier, Item> itemStacks = Collections.emptyMap();
    private Item itemStack;
    private Iterable<Texture> textures;
    private MenuHandler<?> menuHandler = Data.COVER_MENU_HANDLER;
    protected boolean gui = false;

    protected CoverFactory(String domain, String id, CoverSupplier supplier) {
        this.id = id;
        this.supplier = supplier;
        this.domain = domain;
        AntimatterAPI.register(CoverFactory.class, this);
    }

    public final CoverSupplier get() {
        return this.supplier;
    }

    public ItemStack getItem(Tier tier) {
        return tier == null ? this.getItem() : this.itemStacks.getOrDefault(tier, Items.f_41852_).m_7968_();
    }

    public Tier getValidTier() {
        return this.itemStacks.size() > 1 ? this.itemStacks.keySet().iterator().next() : null;
    }

    public Iterable<Texture> getTextures() {
        return this.textures == null ? Collections::emptyIterator : this.textures;
    }

    public ItemStack getItem() {
        return this.itemStack == null ? ItemStack.f_41583_ : this.itemStack.m_7968_();
    }

    public MenuHandler<?> getMenuHandler() {
        return this.menuHandler;
    }

    void setItems(Map<Tier, Item> stacks) {
        this.itemStack = stacks.remove(null);
        if (this.itemStack == null) {
            this.itemStack = Items.f_41852_;
        }
        this.itemStacks = ImmutableMap.copyOf(stacks);
    }

    void addTextures(Iterable<Texture> textures) {
        this.textures = textures;
    }

    void setHasGui() {
        this.gui = true;
    }

    void setMenuHandler(MenuHandler<?> handler) {
        this.menuHandler = handler;
    }

    public boolean hasGui() {
        return this.gui;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public static Builder builder(CoverSupplier supplier) {
        return new Builder(supplier);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public static CompoundTag writeCover(CompoundTag nbt, ICover cover) {
        CompoundTag inner;
        CoverFactory factory = cover.getFactory();
        nbt.m_128359_(cover.side().m_122411_() + "d", factory.getDomain());
        nbt.m_128359_(cover.side().m_122411_() + "i", factory.getId());
        if (cover.getTier() != null) {
            nbt.m_128359_(cover.side().m_122411_() + "t", cover.getTier().getId());
        }
        if (!(inner = cover.serialize()).m_128456_()) {
            nbt.m_128365_(cover.side().m_122411_() + "c", (Tag)inner);
        }
        return nbt;
    }

    public static ICover readCover(ICoverHandler<?> source, Direction dir, CompoundTag nbt) {
        if (!nbt.m_128441_(dir.m_122411_() + "d")) {
            return null;
        }
        String domain = nbt.m_128461_(dir.m_122411_() + "d");
        String id = nbt.m_128461_(dir.m_122411_() + "i");
        CoverFactory factory = AntimatterAPI.get(CoverFactory.class, id, domain);
        if (factory == null) {
            throw new IllegalStateException("Reading a cover with null factory, game in bad state");
        }
        Tier tier = nbt.m_128441_(dir.m_122411_() + "t") ? AntimatterAPI.get(Tier.class, nbt.m_128461_(dir.m_122411_() + "t")) : null;
        ICover cover = factory.supplier.get(source, tier, dir, factory);
        if (nbt.m_128441_(dir.m_122411_() + "c")) {
            cover.deserialize((CompoundTag)nbt.m_128423_(dir.m_122411_() + "c"));
        }
        return cover;
    }

    public static interface CoverSupplier {
        public ICover get(ICoverHandler<?> var1, @Nullable Tier var2, Direction var3, CoverFactory var4);
    }

    public static class Builder {
        List<Tier> tiers = Collections.singletonList(null);
        final CoverSupplier supplier;
        BiFunction<CoverFactory, Tier, Item> itemBuilder;
        boolean gui = false;
        Iterable<Texture> textures;
        MenuHandler<?> menuHandler;

        public Builder(CoverSupplier supplier) {
            this.supplier = supplier;
        }

        public Builder setTiers(Tier ... tiers) {
            this.tiers = Arrays.asList(tiers);
            return this;
        }

        public Builder item(BiFunction<CoverFactory, Tier, Item> item) {
            this.itemBuilder = item;
            return this;
        }

        public Builder gui() {
            this.gui = true;
            return this;
        }

        public Builder setMenuHandler(MenuHandler<?> handler) {
            this.menuHandler = handler;
            return this;
        }

        public Builder addTextures(Iterable<Texture> textures) {
            this.textures = textures;
            return this;
        }

        public Builder addTextures(Texture ... textures) {
            this.textures = Arrays.asList(textures);
            return this;
        }

        public CoverFactory build(String domain, String id) {
            CoverFactory factory = new CoverFactory(domain, id, this.supplier);
            if (this.itemBuilder != null) {
                Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
                for (Tier tier : this.tiers) {
                    Item stack = this.itemBuilder.apply(factory, tier);
                    map.put(tier, stack);
                }
                factory.setItems((Map<Tier, Item>)map);
            }
            if (this.gui) {
                factory.setHasGui();
                if (this.menuHandler != null) {
                    factory.setMenuHandler(this.menuHandler);
                }
            }
            if (this.textures != null) {
                factory.addTextures(this.textures);
            }
            return factory;
        }
    }
}

