/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.cover;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.cover.CoverFactory;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.cover.ICoverModeHandler;
import muramasa.antimatter.gui.GuiData;
import muramasa.antimatter.gui.GuiInstance;
import muramasa.antimatter.gui.event.IGuiEvent;
import muramasa.antimatter.gui.widget.BackgroundWidget;
import muramasa.antimatter.gui.widget.CoverModeHandlerWidget;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.network.packets.AbstractGuiEventPacket;
import muramasa.antimatter.network.packets.CoverGuiEventPacket;
import muramasa.antimatter.texture.Texture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public abstract class BaseCover
implements ICover,
IGuiHandler.IHaveWidgets {
    @Nonnull
    public final CoverFactory factory;
    @Nonnull
    public final ICoverHandler<?> handler;
    @Nullable
    public final Tier tier;
    @Nullable
    public final GuiData gui;
    public final Direction side;
    private final List<Consumer<GuiInstance>> guiCallbacks = new ObjectArrayList();

    @Override
    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return new ResourceLocation(this.getDomain() + ":block/cover/" + this.getRenderId());
    }

    @Override
    public Direction side() {
        return this.side;
    }

    @Override
    public ICoverHandler<?> source() {
        return this.handler;
    }

    public BaseCover(@Nonnull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        this.factory = Objects.requireNonNull(factory, "Missing factory in BaseCover");
        this.handler = source;
        this.tier = tier;
        this.side = side;
        if (factory.hasGui()) {
            this.gui = new GuiData(this, factory.getMenuHandler());
            this.gui.setEnablePlayerSlots(true);
            this.addGuiCallback(t -> {
                t.addWidget(BackgroundWidget.build(t.handler.getGuiTexture(), t.handler.guiSize(), t.handler.guiHeight()));
                if (this instanceof ICoverModeHandler) {
                    t.addWidget(CoverModeHandlerWidget.build());
                }
            });
        } else {
            this.gui = null;
        }
    }

    @Override
    @Nullable
    public Tier getTier() {
        return this.tier;
    }

    @Override
    public List<Consumer<GuiInstance>> getCallbacks() {
        return this.guiCallbacks;
    }

    @Override
    public void setTextures(BiConsumer<String, Texture> texer) {
        texer.accept("overlay", new Texture(this.factory.getDomain(), "block/cover/" + this.getRenderId()));
    }

    @Override
    public Texture[] getTextures() {
        ArrayList l = new ArrayList();
        this.setTextures((name, tex) -> l.add(tex));
        return l.toArray(new Texture[0]);
    }

    protected String getRenderId() {
        return this.getId();
    }

    public static ResourceLocation getBasicModel() {
        return new ResourceLocation("antimatter:block/cover/basic");
    }

    public static ResourceLocation getBasicDepthModel() {
        return new ResourceLocation("antimatter:block/cover/basic_depth");
    }

    @Override
    public ItemStack getItem() {
        return this.factory.getItem(this.tier);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
    }

    @Override
    public boolean hasGui() {
        return this.factory.hasGui();
    }

    @Override
    public GuiData getGui() {
        return this.gui;
    }

    @Override
    public CompoundTag serialize() {
        return new CompoundTag();
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        return this.hasGui() ? (AbstractContainerMenu)this.getGui().getMenuHandler().menu(this, p_createMenu_3_.m_150109_(), p_createMenu_1_) : null;
    }

    @Override
    public boolean isRemote() {
        return this.handler.getTile().m_58904_().m_5776_();
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return new ResourceLocation(this.factory.getDomain(), "textures/gui/cover/" + this.getId() + ".png");
    }

    @Override
    public AbstractGuiEventPacket createGuiPacket(IGuiEvent event) {
        return new CoverGuiEventPacket(event, this.handler.getTile().m_58899_(), this.side);
    }

    @Override
    public CoverFactory getFactory() {
        return this.factory;
    }
}

