/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.common.event.forge;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.forge.energy.ForgeEnergyContainer;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.capability.forge.AntimatterCaps;
import muramasa.antimatter.common.event.CommonEvents;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.item.IFluidItem;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTypeBlock;
import muramasa.antimatter.ore.BlockOre;
import muramasa.antimatter.structure.StructureCache;
import muramasa.antimatter.tile.TileEntityFakeBlock;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import muramasa.antimatter.tile.multi.TileEntityHatch;
import muramasa.antimatter.tile.pipe.TileEntityCable;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tesseract.api.forge.Provider;
import tesseract.api.forge.TesseractCaps;
import tesseract.api.rf.IRFNode;

@Mod.EventBusSubscriber(modid="antimatter")
public class ForgeCommonEvents {
    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open ev) {
        CommonEvents.onContainerOpen(ev.getPlayer(), ev.getContainer());
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent e) {
        CommonEvents.onItemCrafted(e.getInventory(), e.getPlayer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        CommonEvents.placeBlock(event.getPlacedAgainst(), event.getEntity(), event.getWorld(), event.getPos(), event.getPlacedBlock());
    }

    @SubscribeEvent
    public static void onAnvilUpdated(AnvilUpdateEvent event) {
        ItemStack right;
        ItemStack left = event.getLeft();
        if (CommonEvents.anvilUpdate(left, right = event.getRight())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        CommonEvents.lootTableLoad(event.getTable(), event.getName());
    }

    @SubscribeEvent
    public static void remapMissingBlocks(RegistryEvent.MissingMappings<Block> event) {
        event.getMappings("kubejs").forEach(map -> {
            Block replacement;
            Material mat;
            String domain = map.key.m_135827_();
            String id = map.key.m_135815_();
            if (id.startsWith("block_") && (mat = Material.get(id.replace("block_", ""))) != Material.NULL) {
                map.remap((IForgeRegistryEntry)((MaterialTypeBlock.IBlockGetter)AntimatterMaterialTypes.BLOCK.get()).get(mat).asBlock());
                return;
            }
            if (id.startsWith("ore_") && (replacement = (Block)AntimatterAPI.get(BlockOre.class, id)) != null) {
                map.remap((IForgeRegistryEntry)replacement);
                return;
            }
            replacement = AntimatterAPI.get(Block.class, id, "antimatter_shared");
            if (replacement != null) {
                map.remap((IForgeRegistryEntry)replacement);
            }
        });
        event.getMappings("antimatter_shared").forEach(map -> {
            Block replacementBlock;
            String id = map.key.m_135815_();
            if (id.equals("basalt")) {
                map.remap((IForgeRegistryEntry)Blocks.f_50137_);
                return;
            }
            String replacement = "";
            if (id.startsWith("fluid_")) {
                replacement = id.replace("fluid_", "fluid_pipe_");
            } else if (id.startsWith("item_")) {
                replacement = id.replace("item_", "item_pipe_");
            } else if (id.contains("vanilla_basalt")) {
                replacement = id.replace("vanilla_basalt", "basalt");
            }
            if (!replacement.isEmpty() && (replacementBlock = AntimatterAPI.get(Block.class, replacement, "antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)replacementBlock);
            }
        });
    }

    @SubscribeEvent
    public static void remapMissingBlockEntities(RegistryEvent.MissingMappings<BlockEntityType<?>> event) {
        event.getMappings("antimatter_shared").forEach(map -> {
            BlockEntityType replacementBlock;
            String id = map.key.m_135815_();
            String replacement = "";
            if (id.startsWith("fluid_")) {
                replacement = id.replace("fluid_", "fluid_pipe_");
            } else if (id.startsWith("item_")) {
                replacement = id.replace("item_", "item_pipe_");
            }
            if (!replacement.isEmpty() && (replacementBlock = AntimatterAPI.get(BlockEntityType.class, replacement, "antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)replacementBlock);
            }
        });
    }

    @SubscribeEvent
    public static void remapMissingItems(RegistryEvent.MissingMappings<Item> event) {
        event.getMappings("antimatter").forEach(map -> {
            Item replacement = AntimatterAPI.get(Item.class, map.key.m_135815_(), "antimatter_shared");
            if (replacement != null) {
                map.remap((IForgeRegistryEntry)replacement);
            }
        });
        event.getMappings("antimatter_shared").forEach(map -> {
            Item replacementBlock;
            String replacement;
            String id = map.key.m_135815_();
            if (id.equals("basalt")) {
                map.remap((IForgeRegistryEntry)Items.f_42051_);
                return;
            }
            if (id.contains("crushed_centrifuged") && (replacement = AntimatterAPI.get(Item.class, id.replace("centrifuged", "refined"), "antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)replacement);
                return;
            }
            replacement = "";
            if (id.startsWith("fluid_")) {
                replacement = id.replace("fluid_", "fluid_pipe_");
            } else if (id.startsWith("item_")) {
                replacement = id.replace("item_", "item_pipe_");
            } else if (id.contains("vanilla_basalt")) {
                replacement = id.replace("vanilla_basalt", "basalt");
            }
            if (!replacement.isEmpty() && (replacementBlock = AntimatterAPI.get(Item.class, replacement, "antimatter_shared")) != null) {
                map.remap((IForgeRegistryEntry)replacementBlock);
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof TileEntityFakeBlock) {
            final TileEntityFakeBlock fakeBlock = (TileEntityFakeBlock)((Object)object);
            event.addCapability(new ResourceLocation("antimatter", "fake_block"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                    if (fakeBlock.controllerPos != null) {
                        fakeBlock.controllerPos.forEach(t -> fakeBlock2.controllers.add((TileEntityBasicMultiMachine)fakeBlock.m_58904_().m_7702_(t)));
                        fakeBlock.controllerPos = null;
                    }
                    for (TileEntityBasicMultiMachine<?> controller : fakeBlock.controllers) {
                        LazyOptional opt = controller.getCapabilityFromFake((Class)AntimatterCaps.CAP_MAP.inverse().get(capability), fakeBlock.m_58899_(), side, fakeBlock.covers.get(side));
                        if (!opt.isPresent()) continue;
                        if (capability == CapabilityEnergy.ENERGY && opt.map(e -> e instanceof IRFNode).orElse(false).booleanValue()) {
                            LazyOptional finalOpt = opt;
                            opt = LazyOptional.of(() -> (ForgeEnergyContainer)finalOpt.map(e -> new ForgeEnergyContainer((EnergyContainer)((IRFNode)e), (BlockEntity)fakeBlock)).get()).cast();
                        }
                        return opt;
                    }
                    return LazyOptional.empty();
                }
            });
        }
        if ((object = event.getObject()) instanceof TileEntityMachine) {
            final TileEntityMachine machine = (TileEntityMachine)object;
            event.addCapability(new ResourceLocation("antimatter", "machine"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    if (machine instanceof TileEntityBasicMultiMachine) {
                        TileEntityBasicMultiMachine multiMachine = (TileEntityBasicMultiMachine)machine;
                        if (cap == AntimatterCaps.COMPONENT_HANDLER_CAPABILITY && multiMachine.componentHandler.isPresent()) {
                            return multiMachine.componentHandler.cast();
                        }
                    }
                    if (machine instanceof TileEntityHatch) {
                        TileEntityHatch hatch = (TileEntityHatch)machine;
                        if (cap == AntimatterCaps.COMPONENT_HANDLER_CAPABILITY && hatch.componentHandler.isPresent()) {
                            return hatch.componentHandler.cast();
                        }
                    }
                    if (cap == AntimatterCaps.COVERABLE_HANDLER_CAPABILITY && machine.coverHandler.isPresent()) {
                        return machine.coverHandler.side(side).cast();
                    }
                    if (side == machine.getFacing() && !machine.allowsFrontIO()) {
                        return LazyOptional.empty();
                    }
                    if (machine.blocksCapability((Class)AntimatterCaps.CAP_MAP.inverse().get(cap), side)) {
                        return LazyOptional.empty();
                    }
                    if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && machine.itemHandler.isPresent()) {
                        return machine.itemHandler.side(side).cast();
                    }
                    if (cap == AntimatterCaps.RECIPE_HANDLER_CAPABILITY && machine.recipeHandler.isPresent()) {
                        return machine.recipeHandler.side(side).cast();
                    }
                    if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && machine.fluidHandler.isPresent()) {
                        return machine.fluidHandler.side(side).cast();
                    }
                    if (cap == TesseractCaps.ENERGY_HANDLER_CAPABILITY || cap == CapabilityEnergy.ENERGY) {
                        if (machine.energyHandler.isPresent()) {
                            return machine.energyHandler.side(side).cast();
                        }
                        if (cap == CapabilityEnergy.ENERGY && machine.rfHandler.isPresent()) {
                            return LazyOptional.of(() -> new ForgeEnergyContainer((EnergyContainer)((IRFNode)machine2.rfHandler.side(side).map(i -> i).orElseThrow()), (BlockEntity)machine)).cast();
                        }
                    }
                    return LazyOptional.empty();
                }
            });
        }
        if ((object = event.getObject()) instanceof TileEntityPipe) {
            final TileEntityPipe pipe = (TileEntityPipe)object;
            event.addCapability(new ResourceLocation("antimatter", "pipe"), new ICapabilityProvider(){

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
                    if (side == null) {
                        return LazyOptional.empty();
                    }
                    if (capability == AntimatterCaps.COVERABLE_HANDLER_CAPABILITY && pipe.coverHandler.isPresent()) {
                        return pipe.coverHandler.cast();
                    }
                    if (!pipe.connects(side)) {
                        return LazyOptional.empty();
                    }
                    if (capability == CapabilityEnergy.ENERGY && pipe instanceof TileEntityCable) {
                        return pipe.getPipeCapHolder().side(side).cast();
                    }
                    try {
                        if (capability == AntimatterCaps.CAP_MAP.get(pipe.getCapClass())) {
                            LazyOptional cap = pipe.getPipeCapHolder().side(side).cast();
                            if (capability == CapabilityEnergy.ENERGY && cap.map(e -> e instanceof IRFNode).orElse(false).booleanValue()) {
                                LazyOptional finalOpt = cap;
                                cap = LazyOptional.of(() -> (ForgeEnergyContainer)finalOpt.map(e -> new ForgeEnergyContainer((EnergyContainer)((IRFNode)e), (BlockEntity)pipe)).get()).cast();
                            }
                            return cap;
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        return LazyOptional.empty();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesEventItem(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (item instanceof IFluidItem) {
            IFluidItem fluidItem = (IFluidItem)item;
            event.addCapability(new ResourceLocation("antimatter", "fluid_item"), (ICapabilityProvider)new Provider(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, () -> fluidItem.getFluidHandlerItem((ItemStack)event.getObject())));
        }
    }

    @SubscribeEvent
    public static void recipeEvent(RecipesUpdatedEvent ev) {
        CommonEvents.recipeEvent(ev.getRecipeManager());
    }

    @SubscribeEvent
    public static void tagsEvent(TagsUpdatedEvent ev) {
        CommonEvents.tagsEvent();
    }

    @SubscribeEvent
    public static void biomeLoadEvent(BiomeLoadingEvent event) {
        AntimatterWorldGenerator.reloadEvent(event.getName(), event.getClimate(), event.getCategory(), event.getEffects(), (BiomeGenerationSettings.Builder)event.getGeneration(), (MobSpawnSettings.Builder)event.getSpawns());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        StructureCache.onWorldUnload(event.getWorld());
    }
}

