/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.common.event;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.datagen.providers.AntimatterBlockLootProvider;
import muramasa.antimatter.gui.container.IAntimatterContainer;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.proxy.ClientHandler;
import muramasa.antimatter.registration.Side;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class CommonEvents {
    public static void lootTableLoad(LootTable table, ResourceLocation name) {
        Block block;
        ResourceLocation blockId;
        if (AntimatterPlatformUtils.getLootTableID(table).m_135815_().startsWith("blocks/") && AntimatterPlatformUtils.blockExists(blockId = new ResourceLocation(AntimatterPlatformUtils.getLootTableID(table).m_135827_(), name.m_135815_().replace("blocks/", ""))) && ((block = AntimatterPlatformUtils.getBlockFromId(blockId)) == Blocks.f_50126_ || block == Blocks.f_50354_ || block == Blocks.f_50568_)) {
            AntimatterPlatformUtils.addPool(table, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_6509_(AntimatterBlockLootProvider.SAW).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_79082_());
        }
    }

    public static boolean anvilUpdate(ItemStack left, ItemStack right) {
        Item item;
        if (left.m_41720_() == right.m_41720_() && (item = left.m_41720_()) instanceof IAntimatterTool) {
            IAntimatterTool leftTool = (IAntimatterTool)item;
            item = right.m_41720_();
            if (item instanceof IAntimatterTool) {
                IAntimatterTool rightTool = (IAntimatterTool)item;
                if (leftTool.getPrimaryMaterial(left) != rightTool.getPrimaryMaterial(right) || leftTool.getSecondaryMaterial(left) != rightTool.getSecondaryMaterial(right)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void placeBlock(BlockState placedOff, Entity entity, LevelAccessor world, BlockPos pos, BlockState placedBlock) {
        BlockEntity pipe;
        if (placedOff.m_60734_() instanceof BlockPipe && !(placedBlock.m_60734_() instanceof BlockPipe) && entity instanceof Player && !entity.m_6047_() && (pipe = world.m_7702_(pos.m_142300_(entity.m_6350_()))) instanceof TileEntityPipe && placedBlock.m_60734_() instanceof EntityBlock) {
            ((TileEntityPipe)pipe).setConnection(entity.m_6350_().m_122424_());
        }
    }

    public static void onItemCrafted(Container inv, Player player) {
        if (!AntimatterConfig.GAMEPLAY.PLAY_CRAFTING_SOUNDS) {
            return;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            IAntimatterTool tool;
            SoundEvent type;
            Item item = inv.m_8020_(i).m_41720_();
            if (!(item instanceof IAntimatterTool) || (type = (tool = (IAntimatterTool)item).getAntimatterToolType().getUseSound()) == null) continue;
            player.m_5496_(type, 0.75f, 0.75f);
        }
    }

    public static void onContainerOpen(Player player, AbstractContainerMenu container) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (container instanceof IAntimatterContainer) {
                IAntimatterContainer antimatterContainer = (IAntimatterContainer)container;
                antimatterContainer.listeners().add(serverPlayer);
            }
        }
    }

    public static void recipeEvent(RecipeManager manager) {
        if (ClientHandler.isLocal()) {
            AntimatterDynamics.onRecipeCompile(false, manager);
        }
    }

    public static void tagsEvent() {
        if (AntimatterAPI.getSIDE() == Side.CLIENT && !ClientHandler.isLocal()) {
            AntimatterDynamics.onRecipeCompile(true, Minecraft.m_91087_().m_91403_().m_105141_());
        }
    }
}

