/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.scene;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import muramasa.antimatter.client.RenderStateHelper;
import muramasa.antimatter.client.glu.GLU;
import muramasa.antimatter.client.scene.ISceneRenderHook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public abstract class WorldSceneRenderer {
    protected static final FloatBuffer MODELVIEW_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer PROJECTION_MATRIX_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final IntBuffer VIEWPORT_BUFFER = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asIntBuffer();
    protected static final FloatBuffer PIXEL_DEPTH_BUFFER = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    protected static final FloatBuffer OBJECT_POS_BUFFER = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
    public final BlockAndTintGetter world;
    public final Map<Collection<BlockPos>, ISceneRenderHook> renderedBlocksMap;
    private Consumer<WorldSceneRenderer> beforeRender;
    private Consumer<WorldSceneRenderer> afterRender;
    private Consumer<BlockHitResult> onLookingAt;
    private int clearColor;
    private BlockHitResult lastTraceResult;
    private Vector3f eyePos = new Vector3f(0.0f, 0.0f, 10.0f);
    private Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);

    public WorldSceneRenderer(BlockAndTintGetter world) {
        this.world = world;
        this.renderedBlocksMap = new LinkedHashMap<Collection<BlockPos>, ISceneRenderHook>();
    }

    public WorldSceneRenderer setBeforeWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.beforeRender = callback;
        return this;
    }

    public WorldSceneRenderer setAfterWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.afterRender = callback;
        return this;
    }

    public WorldSceneRenderer addRenderedBlocks(Collection<BlockPos> blocks, ISceneRenderHook renderHook) {
        if (blocks != null) {
            this.renderedBlocksMap.put(blocks, renderHook);
        }
        return this;
    }

    public WorldSceneRenderer setOnLookingAt(Consumer<BlockHitResult> onLookingAt) {
        this.onLookingAt = onLookingAt;
        return this;
    }

    public void setClearColor(int clearColor) {
        this.clearColor = clearColor;
    }

    public BlockHitResult getLastTraceResult() {
        return this.lastTraceResult;
    }

    public void render(float x, float y, float width, float height, int mouseX, int mouseY) {
        Vector3f hitPos;
        BlockHitResult result;
        int[] positionedRect = this.getPositionedRect((int)x, (int)y, (int)width, (int)height);
        int[] mousePosition = this.getPositionedRect(mouseX, mouseY, 0, 0);
        mouseX = mousePosition[0];
        mouseY = mousePosition[1];
        this.setupCamera(positionedRect);
        this.drawWorld();
        this.lastTraceResult = null;
        if (this.onLookingAt != null && mouseX > positionedRect[0] && mouseX < positionedRect[0] + positionedRect[2] && mouseY > positionedRect[1] && mouseY < positionedRect[1] + positionedRect[3] && (result = this.rayTrace(hitPos = this.unProject(mouseX, mouseY))) != null && result.m_6662_() != HitResult.Type.MISS) {
            this.lastTraceResult = null;
            this.lastTraceResult = result;
            this.onLookingAt.accept(result);
        }
        this.resetCamera();
    }

    public Vector3f getEyePos() {
        return this.eyePos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }

    public Vector3f getWorldUp() {
        return this.worldUp;
    }

    public void setCameraLookAt(Vector3f eyePos, Vector3f lookAt, Vector3f worldUp) {
        this.eyePos = eyePos;
        this.lookAt = lookAt;
        this.worldUp = worldUp;
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        this.lookAt = lookAt;
        Vec3 vecX = new Vec3(Math.cos(rotationPitch), 0.0, Math.sin(rotationPitch));
        Vec3 vecY = new Vec3(0.0, Math.tan(rotationYaw) * vecX.m_82553_(), 0.0);
        Vec3 pos = new Vec3(vecX.f_82479_, vecX.f_82480_, vecX.f_82481_).m_82549_(vecY).m_82541_().m_82542_(radius, radius, radius);
        this.eyePos = new Vector3f(pos.m_82520_((double)lookAt.m_122239_(), (double)lookAt.m_122260_(), (double)lookAt.m_122269_()));
    }

    protected int[] getPositionedRect(int x, int y, int width, int height) {
        return new int[]{x, y, width, height};
    }

    protected void setupCamera(int[] positionedRect) {
        int x = positionedRect[0];
        int y = positionedRect[1];
        int width = positionedRect[2];
        int height = positionedRect[3];
        RenderStateHelper.disableLightmap();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69949_((int)x, (int)y, (int)width, (int)height);
        this.clearView(x, y, width, height);
        float aspectRatio = (float)width / ((float)height * 1.0f);
        GLU.gluPerspective(60.0f, aspectRatio, 0.1f, 10000.0f);
    }

    protected void clearView(int x, int y, int width, int height) {
        RenderStateHelper.setGlClearColorFromInt(this.clearColor, this.clearColor >> 24);
        RenderSystem.m_69421_((int)16640, (boolean)false);
    }

    protected void resetCamera() {
        Minecraft minecraft = Minecraft.m_91087_();
        RenderSystem.m_69949_((int)0, (int)0, (int)minecraft.m_91268_().m_85441_(), (int)minecraft.m_91268_().m_85442_());
        RenderStateHelper.enableLightmap();
    }

    protected void drawWorld() {
        if (this.beforeRender != null) {
            this.beforeRender.accept(this);
        }
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_69481_();
        mc.m_91097_().m_174784_(TextureAtlas.f_118259_);
        RenderSystem.m_69493_();
        for (RenderType layer : RenderType.m_110506_()) {
            PoseStack matrixstack = new PoseStack();
            Random random = new Random();
            this.renderedBlocksMap.forEach((renderedBlocks, hook) -> {
                if (layer == RenderType.m_110466_()) {
                    MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
                    if (hook != null) {
                        hook.apply(true, layer);
                    }
                    for (BlockPos pos : renderedBlocks) {
                        BlockEntity tile = this.world.m_7702_(pos);
                        if (tile == null) continue;
                        matrixstack.m_85836_();
                        matrixstack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                        matrixstack.m_85849_();
                    }
                    buffers.m_109911_();
                }
                if (hook != null) {
                    hook.apply(false, layer);
                } else {
                    WorldSceneRenderer.setDefaultRenderLayerState(layer);
                }
                BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                BlockRenderDispatcher blockrendererdispatcher = mc.m_91289_();
                for (BlockPos pos : renderedBlocks) {
                    BlockState state = this.world.m_8055_(pos);
                    Block block = state.m_60734_();
                    BlockEntity te = this.world.m_7702_(pos);
                    if (block != Blocks.f_50016_) continue;
                }
                Tesselator.m_85913_().m_85914_();
                Tesselator.m_85913_().m_85915_();
            });
        }
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
        if (this.afterRender != null) {
            this.afterRender.accept(this);
        }
    }

    public static void setDefaultRenderLayerState(RenderType layer) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (layer == RenderType.m_110466_()) {
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            RenderSystem.m_69458_((boolean)false);
        } else {
            RenderSystem.m_69482_();
            RenderSystem.m_69461_();
            RenderSystem.m_69458_((boolean)true);
        }
    }

    public BlockHitResult rayTrace(Vector3f hitPos) {
        Vec3 startPos = new Vec3((double)this.eyePos.m_122239_(), (double)this.eyePos.m_122260_(), (double)this.eyePos.m_122269_());
        hitPos.m_122261_(2.0f);
        Vec3 endPos = new Vec3((double)hitPos.m_122239_() - startPos.f_82479_, (double)hitPos.m_122260_() - startPos.f_82480_, (double)hitPos.m_122269_() - startPos.f_82481_);
        return this.world.m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
    }

    public Vector3f project(BlockPos pos) {
        GL11.glGetFloatv((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloatv((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetIntegerv((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluProject((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + 0.5f, MODELVIEW_MATRIX_BUFFER, PROJECTION_MATRIX_BUFFER, VIEWPORT_BUFFER, OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float winX = OBJECT_POS_BUFFER.get();
        float winY = OBJECT_POS_BUFFER.get();
        float winZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(winX, winY, winZ);
    }

    public Vector3f unProject(int mouseX, int mouseY) {
        GL11.glReadPixels((int)mouseX, (int)mouseY, (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)PIXEL_DEPTH_BUFFER);
        PIXEL_DEPTH_BUFFER.rewind();
        float pixelDepth = PIXEL_DEPTH_BUFFER.get();
        PIXEL_DEPTH_BUFFER.rewind();
        GL11.glGetFloatv((int)2982, (FloatBuffer)MODELVIEW_MATRIX_BUFFER);
        GL11.glGetFloatv((int)2983, (FloatBuffer)PROJECTION_MATRIX_BUFFER);
        GL11.glGetIntegerv((int)2978, (IntBuffer)VIEWPORT_BUFFER);
        MODELVIEW_MATRIX_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        VIEWPORT_BUFFER.rewind();
        GLU.gluUnProject(mouseX, mouseY, pixelDepth, MODELVIEW_MATRIX_BUFFER, PROJECTION_MATRIX_BUFFER, VIEWPORT_BUFFER, OBJECT_POS_BUFFER);
        VIEWPORT_BUFFER.rewind();
        PROJECTION_MATRIX_BUFFER.rewind();
        MODELVIEW_MATRIX_BUFFER.rewind();
        OBJECT_POS_BUFFER.rewind();
        float posX = OBJECT_POS_BUFFER.get();
        float posY = OBJECT_POS_BUFFER.get();
        float posZ = OBJECT_POS_BUFFER.get();
        OBJECT_POS_BUFFER.rewind();
        return new Vector3f(posX, posY, posZ);
    }

    protected BlockHitResult screenPos2BlockPosFace(int mouseX, int mouseY, int x, int y, int width, int height) {
        RenderSystem.m_69482_();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f hitPos = this.unProject(mouseX, mouseY);
        BlockHitResult result = this.rayTrace(hitPos);
        this.resetCamera();
        return result;
    }

    protected Vector3f blockPos2ScreenPos(BlockPos pos, boolean depth, int x, int y, int width, int height) {
        RenderSystem.m_69482_();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f winPos = this.project(pos);
        this.resetCamera();
        return winPos;
    }

    public static class BlockPosFace
    extends BlockPos {
        public final Direction facing;

        public BlockPosFace(BlockPos pos, Direction facing) {
            super((Vec3i)pos);
            this.facing = facing;
        }

        public boolean equals(@Nullable Object bp) {
            if (bp instanceof BlockPosFace) {
                return super.equals(bp) && ((BlockPosFace)((Object)bp)).facing == this.facing;
            }
            return false;
        }
    }
}

