/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.model.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import muramasa.antimatter.client.IAntimatterModel;
import muramasa.antimatter.client.model.AntimatterModel;
import muramasa.antimatter.client.model.loader.AntimatterModelLoader;
import muramasa.antimatter.dynamic.DynamicModel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;

public class DynamicModelLoader
extends AntimatterModelLoader<DynamicModel> {
    public DynamicModelLoader(ResourceLocation loc) {
        super(loc);
    }

    @Override
    public DynamicModel readModel(JsonDeserializationContext context, JsonObject json) {
        try {
            Int2ObjectOpenHashMap configs = new Int2ObjectOpenHashMap();
            for (JsonElement e : json.getAsJsonArray("config")) {
                if (!e.isJsonObject() || !e.getAsJsonObject().has("id") || !e.getAsJsonObject().has("models")) continue;
                int id = e.getAsJsonObject().get("id").getAsInt();
                configs.put(id, (Object)this.buildModels(context, e.getAsJsonObject().get("models").getAsJsonArray()));
            }
            String staticMapId = "";
            if (json.has("staticMap") && json.get("staticMap").isJsonPrimitive()) {
                staticMapId = json.get("staticMap").getAsString();
            }
            ResourceLocation particle = json.has("particle") ? new ResourceLocation(json.get("particle").getAsString()) : MissingTextureAtlasSprite.m_118071_();
            return new DynamicModel(particle, (Int2ObjectOpenHashMap<IAntimatterModel[]>)configs, staticMapId);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught error deserializing model : " + e);
        }
    }

    public IAntimatterModel[] buildModels(JsonDeserializationContext context, JsonArray array) {
        IAntimatterModel[] models = new IAntimatterModel[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            if (!array.get(i).isJsonObject()) continue;
            models[i] = new AntimatterModel((UnbakedModel)context.deserialize((JsonElement)array.get(i).getAsJsonObject(), BlockModel.class), this.buildRotations(array.get(i).getAsJsonObject()));
        }
        return models;
    }
}

