/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.model.loader;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.client.ModelUtils;
import muramasa.antimatter.client.model.AntimatterModel;
import muramasa.antimatter.client.model.loader.AntimatterModelLoader;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;

public class DefaultModelLoader
extends AntimatterModelLoader<AntimatterModel> {
    public DefaultModelLoader(ResourceLocation loc) {
        super(loc);
    }

    @Override
    @Nonnull
    public AntimatterModel readModel(JsonDeserializationContext context, JsonObject json) {
        try {
            UnbakedModel baseModel = json.has("model") && json.get("model").isJsonObject() ? (UnbakedModel)context.deserialize(json.get("model"), BlockModel.class) : ModelUtils.getMissingModel();
            return new AntimatterModel(baseModel, this.buildRotations(json));
        }
        catch (Exception e) {
            return this.onModelLoadingException(e);
        }
    }

    public AntimatterModel onModelLoadingException(Exception e) {
        Antimatter.LOGGER.error("ModelLoader Exception for " + this.getLoc().toString());
        e.printStackTrace();
        return new AntimatterModel(ModelUtils.getMissingModel(), new int[0]);
    }
}

