/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import muramasa.antimatter.client.model.IModelBuilder;
import muramasa.antimatter.client.model.IModelConfiguration;
import muramasa.antimatter.client.model.ISimpleModel;
import muramasa.antimatter.client.model.loader.IAntimatterModelLoader;
import muramasa.antimatter.mixin.client.BlockModelAccessor;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class VanillaProxy
implements ISimpleModel {
    private final List<BlockElement> elements;

    public VanillaProxy(List<BlockElement> list) {
        this.elements = list;
    }

    @Override
    public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        for (BlockElement blockpart : this.elements) {
            for (Direction direction : blockpart.f_111310_.keySet()) {
                BlockElementFace blockpartface = (BlockElementFace)blockpart.f_111310_.get(direction);
                TextureAtlasSprite textureatlassprite1 = spriteGetter.apply(owner.resolveTexture(blockpartface.f_111356_));
                if (blockpartface.f_111354_ == null) {
                    modelBuilder.addGeneralQuad(BlockModelAccessor.invokeBakeFace(blockpart, blockpartface, textureatlassprite1, direction, modelTransform, modelLocation));
                    continue;
                }
                modelBuilder.addFaceQuad(Direction.m_122384_((Matrix4f)modelTransform.m_6189_().m_121104_(), (Direction)blockpartface.f_111354_), BlockModelAccessor.invokeBakeFace(blockpart, blockpartface, textureatlassprite1, direction, modelTransform, modelLocation));
            }
        }
    }

    @Override
    public Collection<Material> getMaterials(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        for (BlockElement part : this.elements) {
            for (BlockElementFace face : part.f_111310_.values()) {
                Material texture = owner.resolveTexture(face.f_111356_);
                if (Objects.equals(texture, MissingTextureAtlasSprite.m_118071_().toString())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.f_111356_, (Object)owner.getModelName()));
                }
                textures.add(texture);
            }
        }
        return textures;
    }

    public static class Loader
    implements IAntimatterModelLoader<VanillaProxy> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public VanillaProxy readModel(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            List<BlockElement> list = this.getModelElements(deserializationContext, modelContents);
            return new VanillaProxy(list);
        }

        private List<BlockElement> getModelElements(JsonDeserializationContext deserializationContext, JsonObject object) {
            ArrayList list = Lists.newArrayList();
            if (object.has("elements")) {
                for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)object, (String)"elements")) {
                    list.add((BlockElement)deserializationContext.deserialize(jsonelement, BlockElement.class));
                }
            }
            return list;
        }

        @Override
        public String getId() {
            return "vanilla_proxy";
        }
    }
}

