/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import muramasa.antimatter.client.IAntimatterModel;
import muramasa.antimatter.client.baked.BakedMachineSide;
import muramasa.antimatter.client.baked.CoverBakedModel;
import muramasa.antimatter.client.baked.GroupedBakedModel;
import muramasa.antimatter.client.model.IModelConfiguration;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class AntimatterGroupedModel
implements IAntimatterModel {
    final Map<String, IAntimatterModel> models;
    final ResourceLocation particle;

    public AntimatterGroupedModel(ResourceLocation particle, Map<String, IAntimatterModel> models) {
        this.models = models;
        this.particle = particle;
    }

    @Override
    public BakedModel bakeModel(ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ResourceLocation loc) {
        return null;
    }

    @Override
    public BakedModel bakeModel(IModelConfiguration configuration, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
        ImmutableMap.Builder<String, BakedModel> builder = AntimatterGroupedModel.buildParts(configuration, bakery, getter, transform, overrides, loc, this.models.entrySet());
        return new GroupedBakedModel(getter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_())), (Map<String, BakedModel>)builder.build());
    }

    protected static ImmutableMap.Builder<String, BakedModel> buildParts(IModelConfiguration configuration, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc, Set<Map.Entry<String, IAntimatterModel>> entries) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, IAntimatterModel> entry : entries) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().bake(configuration, bakery, getter, transform, overrides, loc));
        }
        return builder;
    }

    @Override
    public Collection<Material> getMaterials(IModelConfiguration configuration, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.models.values().stream().flatMap(t -> t.getMaterials(configuration, modelGetter, missingTextureErrors).stream()).collect(Collectors.toList());
    }

    public static class MachineSideModel
    extends AntimatterGroupedModel {
        public MachineSideModel(AntimatterGroupedModel model) {
            super(model.particle, model.models);
        }

        @Override
        public BakedModel bakeModel(IModelConfiguration configuration, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
            ImmutableMap.Builder<String, BakedModel> builder = MachineSideModel.buildParts(configuration, bakery, getter, transform, overrides, loc, this.models.entrySet());
            return new BakedMachineSide(getter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_())), (Map<String, BakedModel>)builder.build());
        }
    }

    public static class CoverModel
    extends AntimatterGroupedModel {
        public CoverModel(AntimatterGroupedModel model) {
            super(model.particle, model.models);
        }

        @Override
        public BakedModel bakeModel(IModelConfiguration configuration, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
            ImmutableMap.Builder<String, BakedModel> builder = CoverModel.buildParts(configuration, bakery, getter, transform, overrides, loc, this.models.entrySet());
            return new CoverBakedModel(getter.apply(new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_())), (Map<String, BakedModel>)builder.build());
        }
    }
}

