/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.forge;

import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.client.baked.IAntimatterBakedModel;
import muramasa.antimatter.mixin.forge.client.SimpleBakedModel$BuilderAccessor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.TransformationHelper;

public class ModelUtilsImpl {
    public static Function<ResourceLocation, UnbakedModel> getDefaultModelGetter() {
        return ForgeModelBakery.defaultModelGetter();
    }

    public static Function<Material, TextureAtlasSprite> getDefaultTextureGetter() {
        return ForgeModelBakery.defaultTextureGetter();
    }

    public static ModelBakery getModelBakery() {
        return ForgeModelBakery.instance();
    }

    public static void setLightData(BakedQuad quad, int light) {
        LightUtil.setLightData((BakedQuad)quad, (int)light);
    }

    public static SimpleBakedModel.Builder createSimpleModelBuilder(boolean smoothLighting, boolean sideLit, boolean isShadedInGui, ItemTransforms transforms, ItemOverrides overrides) {
        return SimpleBakedModel$BuilderAccessor.antimatter$create(smoothLighting, sideLit, isShadedInGui, transforms, overrides);
    }

    public static List<BakedQuad> getQuadsFromBaked(BakedModel model, BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos) {
        if (model instanceof IAntimatterBakedModel) {
            IAntimatterBakedModel antimatterBaked = (IAntimatterBakedModel)model;
            return antimatterBaked.getQuads(state, side, rand, level, pos);
        }
        IModelData data = model.getModelData(level, pos, state, (IModelData)EmptyModelData.INSTANCE);
        return model.getQuads(state, side, rand, data);
    }

    public static BakedModel getBakedFromModel(BlockModel model, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ResourceLocation loc) {
        List generalQuads = model.m_111449_(bakery, model, getter, transform, loc, true).getQuads(null, null, (Random)Ref.RNG, (IModelData)EmptyModelData.INSTANCE);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, ItemOverrides.f_111734_, true).m_119528_(getter.apply(model.m_111480_("particle")));
        generalQuads.forEach(arg_0 -> ((SimpleBakedModel.Builder)builder).m_119526_(arg_0));
        return builder.m_119533_();
    }

    public static BakedModel getSimpleBakedModel(BakedModel baked) {
        Object2ObjectOpenHashMap faceQuads = new Object2ObjectOpenHashMap();
        Arrays.stream(Ref.DIRS).forEach(arg_0 -> ModelUtilsImpl.lambda$getSimpleBakedModel$0((Map)faceQuads, baked, arg_0));
        return new SimpleBakedModel(baked.getQuads(null, null, (Random)Ref.RNG, (IModelData)EmptyModelData.INSTANCE), (Map)faceQuads, baked.m_7541_(), baked.m_7547_(), baked.m_7539_(), baked.m_6160_(), baked.m_7442_(), baked.m_7343_());
    }

    public static Quaternion quatFromXYZ(Vector3f xyz, boolean degrees) {
        return TransformationHelper.quatFromXYZ((Vector3f)xyz, (boolean)degrees);
    }

    public static List<BakedQuad> trans(List<BakedQuad> quads, Transformation transform) {
        return new QuadTransformer(transform.blockCenterToCorner()).processMany(quads);
    }

    public static void setRenderLayer(Block block, RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
    }

    public static void setRenderLayer(Fluid fluid, RenderType renderType) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)renderType);
    }

    private static /* synthetic */ void lambda$getSimpleBakedModel$0(Map faceQuads, BakedModel baked, Direction d) {
        faceQuads.put(d, baked.getQuads(null, d, (Random)Ref.RNG, (IModelData)EmptyModelData.INSTANCE));
    }
}

