/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.event.forge;

import muramasa.antimatter.client.SoundHelper;
import muramasa.antimatter.client.event.ClientEvents;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.tool.IAntimatterTool;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="antimatter", value={Dist.CLIENT})
public class ClientEventsForge {
    @SubscribeEvent
    public static void onBlockHighlight(DrawSelectionEvent.HighlightBlock event) {
        if (ClientEvents.onBlockHighlight(event.getLevelRenderer(), event.getCamera(), event.getTarget(), event.getPartialTicks(), event.getPoseStack(), event.getMultiBufferSource())) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    protected static void onTooltipAdd(ItemTooltipEvent ev) {
        MaterialType.addTooltip(ev.getItemStack(), ev.getToolTip(), ev.getPlayer(), ev.getFlags());
        ClientEvents.onItemTooltip(ev.getFlags(), ev.getToolTip());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            Player player = e.player;
            if (player == null || player.m_21205_().m_41619_()) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (!(stack.m_41720_() instanceof IAntimatterTool)) {
                return;
            }
            IAntimatterTool item = (IAntimatterTool)stack.m_41720_();
            if (item.getAntimatterToolType().getUseAction() != UseAnim.NONE && player.f_20911_) {
                item.getItem().onUsingTick(stack, (LivingEntity)player, stack.m_41613_());
            }
        }
    }

    @SubscribeEvent
    public static void onRenderDebugInfo(RenderGameOverlayEvent.Text e) {
        ClientEvents.onRenderDebugInfo(e.getLeft());
    }

    @SubscribeEvent
    public static void onGuiMouseScrollPre(ScreenEvent.MouseScrollEvent.Pre e) {
        ClientEvents.onGuiMouseScrollPre(e.getScrollDelta());
    }

    @SubscribeEvent
    public static void onGuiMouseClickPre(ScreenEvent.MouseClickedEvent.Pre e) {
        ClientEvents.onGuiMouseClickPre(e.getButton());
    }

    @SubscribeEvent
    public static void onGuiMouseReleasedPre(ScreenEvent.MouseReleasedEvent.Pre e) {
        ClientEvents.onGuiMouseReleasedPre(e.getButton());
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload ev) {
        SoundHelper.worldUnload(ev.getWorld());
    }
}

