/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.event;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import muramasa.antimatter.Ref;
import muramasa.antimatter.behaviour.IBehaviour;
import muramasa.antimatter.block.IInfoProvider;
import muramasa.antimatter.client.RenderHelper;
import muramasa.antimatter.cover.IHaveCover;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.machine.BlockMachine;
import muramasa.antimatter.mixin.client.LevelRendererAccessor;
import muramasa.antimatter.mixin.client.MultiPlayerGameModeAccessor;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.tool.IAntimatterTool;
import muramasa.antimatter.tool.behaviour.BehaviourAOEBreak;
import muramasa.antimatter.tool.behaviour.BehaviourExtendedHighlight;
import muramasa.antimatter.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    public static double lastDelta;
    public static boolean leftDown;
    public static boolean rightDown;
    public static boolean middleDown;

    public static boolean onBlockHighlight(LevelRenderer levelRenderer, Camera camera, BlockHitResult target, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource) {
        double modZ;
        double modY;
        double modX;
        LocalPlayer player = ClientEvents.MC.f_91074_;
        Level world = player.m_20193_();
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_() || !(stack.m_41720_() instanceof IAntimatterTool) && !(stack.m_41720_() instanceof IHaveCover)) {
            return false;
        }
        if (stack.m_41720_() instanceof IHaveCover) {
            if (player.m_6047_()) {
                return false;
            }
            RenderHelper.onDrawHighlight((Player)player, levelRenderer, camera, (HitResult)target, partialTick, poseStack, bufferSource, b -> b instanceof BlockMachine || b instanceof BlockPipe, BehaviourExtendedHighlight.COVER_FUNCTION);
            return true;
        }
        IAntimatterTool item = (IAntimatterTool)stack.m_41720_();
        AntimatterToolType type = item.getAntimatterToolType();
        if (player.m_6047_() && type != AntimatterDefaultTools.WRENCH && type != AntimatterDefaultTools.ELECTRIC_WRENCH && type != AntimatterDefaultTools.CROWBAR && type != AntimatterDefaultTools.WIRE_CUTTER) {
            return false;
        }
        InteractionResult res = item.onGenericHighlight((Player)player, levelRenderer, camera, (HitResult)target, partialTick, poseStack, bufferSource);
        if (res == InteractionResult.FAIL) {
            return true;
        }
        if (res.m_19080_()) {
            return false;
        }
        IBehaviour<IAntimatterTool> behaviour = type.getBehaviour("aoe_break");
        if (!(behaviour instanceof BehaviourAOEBreak)) {
            return false;
        }
        BehaviourAOEBreak aoeBreak = (BehaviourAOEBreak)behaviour;
        BlockPos currentPos = target.m_82425_();
        BlockState state = world.m_8055_(currentPos);
        if (state.m_60795_() || !Utils.isToolEffective(item, stack, state) || !item.getDataTag(stack).m_128471_("aoe")) {
            return false;
        }
        Vec3 viewPosition = camera.m_90583_();
        Entity entity = camera.m_90592_();
        VertexConsumer builderLines = bufferSource.m_6299_((RenderType)RenderType.f_110371_);
        double viewX = viewPosition.f_82479_;
        double viewY = viewPosition.f_82480_;
        double viewZ = viewPosition.f_82481_;
        ImmutableSet<BlockPos> positions = Utils.getHarvestableBlocksToBreak(world, (Player)player, item, stack, aoeBreak.getColumn(), aoeBreak.getRow(), aoeBreak.getDepth());
        for (BlockPos nextPos : positions) {
            modX = (double)nextPos.m_123341_() - viewX;
            modY = (double)nextPos.m_123342_() - viewY;
            modZ = (double)nextPos.m_123343_() - viewZ;
            VoxelShape shape = world.m_8055_(nextPos).m_60651_((BlockGetter)world, nextPos, CollisionContext.m_82750_((Entity)entity));
            poseStack.m_85836_();
            LevelRendererAccessor.renderShape(poseStack, builderLines, shape, modX, modY, modZ, 0.0f, 0.0f, 0.0f, 0.4f);
            poseStack.m_85849_();
        }
        if (ClientEvents.MC.f_91072_.m_105296_()) {
            for (BlockPos nextPos : positions) {
                modX = (double)nextPos.m_123341_() - viewX;
                modY = (double)nextPos.m_123342_() - viewY;
                modZ = (double)nextPos.m_123343_() - viewZ;
                int partialDamage = (int)(((MultiPlayerGameModeAccessor)ClientEvents.MC.f_91072_).getDestroyProgress() * 10.0f) - 1;
                poseStack.m_85836_();
                poseStack.m_85837_(modX, modY, modZ);
                if (partialDamage == -1) {
                    return false;
                }
                SheetedDecalTextureGenerator builderBreak = new SheetedDecalTextureGenerator(bufferSource.m_6299_((RenderType)ModelBakery.f_119229_.get(partialDamage)), poseStack.m_85850_().m_85861_(), poseStack.m_85850_().m_85864_());
                MC.m_91289_().m_110918_(world.m_8055_(nextPos), nextPos, (BlockAndTintGetter)world, poseStack, (VertexConsumer)builderBreak);
                poseStack.m_85849_();
            }
        }
        return false;
    }

    public static void onPlayerTickEnd(Player player) {
        if (player == null || player.m_21205_().m_41619_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof IAntimatterTool)) {
            return;
        }
        IAntimatterTool item = (IAntimatterTool)stack.m_41720_();
        if (item.getAntimatterToolType().getUseAction() == UseAnim.NONE || player.f_20911_) {
            // empty if block
        }
    }

    public static void onRenderDebugInfo(ArrayList<String> left) {
        BlockEntity tile;
        if (!ClientEvents.MC.f_91066_.f_92063_ || ClientEvents.MC.f_91077_ == null || ClientEvents.MC.f_91077_.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        BlockPos pos = new BlockPos(ClientEvents.MC.f_91077_.m_82450_());
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IInfoProvider) {
            IInfoProvider info = (IInfoProvider)block;
            left.add("");
            left.add(ChatFormatting.AQUA + "[Antimatter Debug Server]");
            left.addAll(info.getInfo((List<String>)new ObjectArrayList(), (Level)world, state, pos));
        }
        if ((tile = world.m_7702_(pos)) instanceof TileEntityBase) {
            TileEntityBase b = (TileEntityBase)tile;
            left.addAll(b.getInfo());
        }
        if (ClientEvents.MC.f_91074_.m_6047_()) {
            left.add("");
            left.add(ChatFormatting.AQUA + "[Antimatter Debug Client]");
        }
    }

    public static void onItemTooltip(TooltipFlag flags, List<Component> tooltip) {
        List<ResourceLocation> tags;
        if (flags.m_7050_() && Ref.SHOW_ITEM_TAGS && !(tags = Collections.emptyList()).isEmpty()) {
            tooltip.add((Component)new TextComponent("Tags:").m_130940_(ChatFormatting.DARK_GRAY));
            for (ResourceLocation loc : tags) {
                tooltip.add((Component)new TextComponent(loc.toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public static void onGuiMouseScrollPre(double lastScrollDelta) {
        lastDelta = lastScrollDelta;
    }

    public static void onGuiMouseClickPre(int button) {
        switch (button) {
            case 0: {
                leftDown = true;
                break;
            }
            case 1: {
                rightDown = true;
                break;
            }
            case 2: {
                middleDown = true;
            }
        }
    }

    public static void onGuiMouseReleasedPre(int button) {
        switch (button) {
            case 0: {
                leftDown = false;
                break;
            }
            case 1: {
                rightDown = false;
                break;
            }
            case 2: {
                middleDown = false;
            }
        }
    }
}

