/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.dynamic;

import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.client.dynamic.IDynamicModelProvider;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DynamicTextureProvider<T extends IDynamicModelProvider, U> {
    private final Function<BuilderData, List<BakedQuad>> builder;

    public DynamicTextureProvider(@Nonnull Function<BuilderData, List<BakedQuad>> builder) {
        this.builder = builder;
    }

    public List<BakedQuad>[] getQuads(String type, BlockState state, T t, U key, BlockAndTintGetter level, BlockPos pos) {
        return this.bakeQuads(type, state, t, key, level, pos);
    }

    private List<BakedQuad>[] bakeQuads(String type, BlockState state, T c, U key, BlockAndTintGetter level, BlockPos pos) {
        List[] bakedArray = new List[Ref.DIRS.length];
        for (Direction dir : Ref.DIRS) {
            bakedArray[dir.m_122411_()] = this.builder.apply(new BuilderData(this, type, (Random)Ref.RNG, state, level, pos, c, key, dir));
        }
        return bakedArray;
    }

    public static class BuilderData {
        public Random rand;
        @Nullable
        public BlockState state;
        public BlockAndTintGetter level;
        public BlockPos pos;
        public T source;
        public U key;
        public Direction currentDir;
        public String type;
        final /* synthetic */ DynamicTextureProvider this$0;

        public BuilderData(String type, Random r, BlockState s, BlockAndTintGetter l, BlockPos p, T t, U u, Direction dir) {
            this.this$0 = this$0;
            this.rand = r;
            this.state = s;
            this.level = l;
            this.pos = p;
            this.source = t;
            this.key = u;
            this.currentDir = dir;
            this.type = type;
        }

        BlockEntity getBlockEntity() {
            return this.level.m_7702_(this.pos);
        }
    }
}

