/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.baked;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.client.ModelUtils;
import muramasa.antimatter.client.baked.AntimatterBakedModel;
import muramasa.antimatter.client.dynamic.DynamicTexturer;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.mixin.client.ChunkReaderAccessor;
import muramasa.antimatter.structure.StructureCache;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tile.TileEntityFakeBlock;
import muramasa.antimatter.tile.multi.TileEntityBasicMultiMachine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ProxyBakedModel
extends AntimatterBakedModel<ProxyBakedModel> {
    public ProxyBakedModel(TextureAtlasSprite particle) {
        super(particle);
    }

    protected Level getWorld(BlockAndTintGetter reader) {
        if (reader instanceof Level) {
            Level l = (Level)reader;
            return l;
        }
        if (reader instanceof RenderChunkRegion) {
            RenderChunkRegion region = (RenderChunkRegion)reader;
            return ((ChunkReaderAccessor)region).getLevel();
        }
        return null;
    }

    @Override
    public TextureAtlasSprite getParticleIcon(BlockAndTintGetter getter, BlockPos pos) {
        BlockEntity blockEntity = getter.m_7702_(pos);
        if (!(blockEntity instanceof TileEntityFakeBlock)) {
            return this.m_6160_();
        }
        TileEntityFakeBlock fakeBlock = (TileEntityFakeBlock)blockEntity;
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(fakeBlock.getState());
        return model.m_6160_();
    }

    @Override
    public List<BakedQuad> getBlockQuads(BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull BlockAndTintGetter level, BlockPos pos) {
        TileEntityFakeBlock fake;
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof TileEntityFakeBlock) || (fake = (TileEntityFakeBlock)tile).getState() == null) {
            return Collections.emptyList();
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(fake.getState());
        UnbakedModel m = ModelUtils.getModel((ResourceLocation)BlockModelShaper.m_110895_((BlockState)fake.getState()));
        Collection mats = m.m_5500_(ModelUtils.getDefaultModelGetter(), (Set)Sets.newLinkedHashSet());
        Material first = (Material)mats.iterator().next();
        BlockState cState = Blocks.f_50016_.m_49966_();
        TileEntityBasicMultiMachine machine = StructureCache.getAnyMulti(this.getWorld(level), fake.m_58899_(), TileEntityBasicMultiMachine.class);
        if (machine != null) {
            cState = machine.m_58900_();
        }
        if (side == null) {
            return ModelUtils.getQuadsFromBaked(model, fake.getState(), side, rand, level, pos);
        }
        ICover cover = fake.covers()[side.m_122411_()];
        if (cover.isEmpty()) {
            return ModelUtils.getQuadsFromBaked(model, fake.getState(), side, rand, level, pos);
        }
        DynamicTexturer<ICover, ICover.DynamicKey> texturer = fake.getTexturer(side);
        return texturer.getQuads("fake", new LinkedList<BakedQuad>(), cState, cover, new ICover.DynamicKey(cover.side(), new Texture(first.m_119203_().toString()), cover.getId()), side.m_122411_(), level, pos);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return true;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

