/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.baked;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.pipe.PipeCoverHandler;
import muramasa.antimatter.client.RenderHelper;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.dynamic.DynamicBakedModel;
import muramasa.antimatter.pipe.BlockPipe;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PipeBakedModel
extends DynamicBakedModel {
    public static final Int2ObjectOpenHashMap<BakedModel[]> CONFIGS = new Int2ObjectOpenHashMap();

    public PipeBakedModel(TextureAtlasSprite particle, Int2ObjectOpenHashMap<BakedModel[]> map) {
        super(particle, map);
        this.onlyGeneralQuads();
    }

    @Override
    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, Random rand, BlockAndTintGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof TileEntityPipe)) {
            return super.getBlockQuads(state, side, rand, level, pos);
        }
        TileEntityPipe pipe = (TileEntityPipe)blockEntity;
        List<BakedQuad> quads = super.getBlockQuads(state, side, rand, level, pos);
        PipeCoverHandler covers = (PipeCoverHandler)pipe.coverHandler.orElse(null);
        List<BakedQuad> coverQuads = new LinkedList<BakedQuad>();
        if (covers == null) {
            return quads;
        }
        if (side == null) {
            for (Direction dir : Ref.DIRS) {
                int index;
                Texture tex = ((BlockPipe)state.m_60734_()).getFace();
                ICover c = covers.get(dir);
                if (c.isEmpty()) continue;
                if (pipe.canConnect(dir.m_122411_()) && (index = RenderHelper.findPipeFront(pipe.getPipeSize(), quads, dir)) != -1) {
                    quads.remove(index);
                }
                coverQuads = covers.getTexturer(dir).getQuads("pipe", coverQuads, state, c, new ICover.DynamicKey(dir, tex, c.getId()), dir.m_122411_(), level, pos);
            }
        }
        quads.addAll(coverQuads);
        return quads;
    }
}

