/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.baked;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nonnull;
import muramasa.antimatter.AntimatterProperties;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.CoverHandler;
import muramasa.antimatter.client.DirectionalQuadTransformer;
import muramasa.antimatter.client.ModelUtils;
import muramasa.antimatter.client.RenderHelper;
import muramasa.antimatter.client.baked.AntimatterBakedModel;
import muramasa.antimatter.client.dynamic.DynamicTexturer;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.tile.TileEntityMachine;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MachineBakedModel
extends AntimatterBakedModel<MachineBakedModel> {
    private final ImmutableMap<MachineState, BakedModel[]> sides;

    public MachineBakedModel(TextureAtlasSprite particle, ImmutableMap<MachineState, BakedModel[]> sides) {
        super(particle);
        this.sides = sides;
    }

    protected List<BakedQuad> getCoverQuads(BlockState state, Direction side, Random rand, AntimatterProperties.MachineProperties data, TileEntityMachine<?> machine, BlockAndTintGetter level, BlockPos pos) {
        ICover cover = data.covers[side.m_122411_()];
        if (cover.isEmpty()) {
            return Collections.emptyList();
        }
        Texture tex = machine.getMultiTexture() != null ? machine.getMultiTexture().apply(side) : data.machTexture.apply(side);
        Object list = new ObjectArrayList();
        list = data.coverTexturer.apply(side).getQuads("cover", (List<BakedQuad>)list, state, cover, new ICover.DynamicKey(state, tex, cover.getId()), side.m_122411_(), level, pos);
        return list;
    }

    @Override
    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, Random rand, BlockAndTintGetter level, @Nonnull BlockPos pos) {
        if (side == null) {
            return Collections.emptyList();
        }
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof TileEntityMachine)) {
            return Collections.emptyList();
        }
        TileEntityMachine machine = (TileEntityMachine)tile;
        AntimatterProperties.MachineProperties props = this.getMachineProperty(machine);
        if (props == null) {
            return Collections.emptyList();
        }
        ObjectArrayList quads = new ObjectArrayList(20);
        List<BakedQuad> coverQuads = this.getCoverQuads(state, side, rand, props, machine, level, pos);
        if (!coverQuads.isEmpty()) {
            return coverQuads;
        }
        if (machine.getMultiTexture() != null) {
            Function<Direction, Texture> ft = machine.getMultiTexture();
            return props.machineTexturer.getQuads("machine", (List<BakedQuad>)new ObjectArrayList(), state, props.type, new TileEntityMachine.DynamicKey(new ResourceLocation(props.type.getId()), ft.apply(side), side, props.state, props), side.m_122411_(), level, pos);
        }
        BakedModel model = this.getModel(state, side, props.state);
        for (Direction dir : Ref.DIRS) {
            quads.addAll(ModelUtils.getQuadsFromBaked(model, state, dir, rand, level, pos));
        }
        quads.addAll(ModelUtils.getQuadsFromBaked(model, state, null, rand, level, pos));
        Matrix4f f = new Matrix4f();
        f.m_27624_();
        Transformation mat = new Transformation(f);
        mat = mat.blockCornerToCenter();
        mat = mat.m_121096_(RenderHelper.faceRotation(state));
        mat = mat.blockCenterToCorner();
        DirectionalQuadTransformer transformer = new DirectionalQuadTransformer(mat);
        return transformer.processMany((List<BakedQuad>)quads, side);
    }

    public BakedModel getModel(BlockState state, Direction dir, MachineState m) {
        Vec3i vector3i = dir.m_122436_();
        Vector4f vector4f = new Vector4f((float)vector3i.m_123341_(), (float)vector3i.m_123342_(), (float)vector3i.m_123343_(), 0.0f);
        vector4f.m_123607_(RenderHelper.faceRotation(state).m_121103_().m_121104_());
        Direction side = Direction.m_122372_((float)vector4f.m_123601_(), (float)vector4f.m_123615_(), (float)vector4f.m_123616_());
        return ((BakedModel[])this.sides.get((Object)m))[side.m_122411_()];
    }

    public AntimatterProperties.MachineProperties getMachineProperty(TileEntityMachine<?> machine) {
        ICover[] covers = machine.coverHandler.map(CoverHandler::getAll).orElse(new ICover[]{ICover.empty, ICover.empty, ICover.empty, ICover.empty, ICover.empty, ICover.empty});
        Machine<?> m = machine.getMachineType();
        Function<Direction, Texture> mText = a -> {
            Texture[] tex = machine.getMachineType().getBaseTexture(machine.getMachineTier());
            if (tex.length == 1) {
                return tex[0];
            }
            return tex[a.m_122411_()];
        };
        MachineState st = machine.getMachineState().getTextureState();
        Function<Direction, DynamicTexturer<ICover, ICover.DynamicKey>> tx = a -> machine.coverHandler.map(t -> t.getTexturer((Direction)a)).orElse(null);
        AntimatterProperties.MachineProperties mh = new AntimatterProperties.MachineProperties(m, machine.getMachineTier(), covers, st, mText, (DynamicTexturer)machine.multiTexturer.m_13971_(), tx);
        return mh;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return true;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

