/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client.baked;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.client.baked.GroupedBakedModel;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.util.Utils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverBakedModel
extends GroupedBakedModel {
    public CoverBakedModel(TextureAtlasSprite p, Map<String, BakedModel> models) {
        super(p, models);
    }

    @Override
    public List<BakedQuad> getBlockQuads(BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull BlockAndTintGetter level, BlockPos pos) {
        return this.getBlockQuads(state, side, rand, level, pos, null);
    }

    public List<BakedQuad> getBlockQuads(BlockState state, @javax.annotation.Nullable Direction side, @Nonnull Random rand, @Nonnull BlockAndTintGetter level, BlockPos pos, Predicate<Map.Entry<String, BakedModel>> predicate) {
        if (predicate == null) {
            return Collections.emptyList();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Map.Entry t : this.models.entrySet()) {
            if (!predicate.test(t)) continue;
            quads.addAll(((BakedModel)t.getValue()).m_6840_(state, null, rand));
        }
        return quads;
    }

    @Nonnull
    public static EnumMap<Direction, Byte> addCoverModelData(Direction side, ICoverHandler<?> handler) {
        EnumMap<Direction, Byte> map = new EnumMap<Direction, Byte>(Direction.class);
        if (handler == null) {
            return map;
        }
        byte value = 0;
        for (Direction dir : new Direction[]{Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN}) {
            Direction rotated = Utils.rotate(side, dir);
            ICover cover = handler.get(rotated);
            if (!cover.isEmpty()) continue;
            byte coverByte = (byte)(1 << dir.m_122411_());
            value = (byte)(value | coverByte);
        }
        map.put(side, value);
        return map;
    }
}

