/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import muramasa.antimatter.Ref;
import muramasa.antimatter.client.forge.RenderHelperImpl;
import muramasa.antimatter.item.ItemBattery;
import muramasa.antimatter.mixin.client.LevelRendererAccessor;
import muramasa.antimatter.mixin.client.VertexFormatAccessor;
import muramasa.antimatter.pipe.PipeSize;
import muramasa.antimatter.tool.armor.MaterialArmor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidStack;
import tesseract.FluidPlatformUtils;
import tesseract.TesseractCapUtils;
import tesseract.graph.Connectivity;

public class RenderHelper {
    static float INDENTATION_SIDE = 0.25f;
    static double INTERACT_DISTANCE = 5.0;

    public static float xFromQuad(BakedQuad quad, int index) {
        int size = ((VertexFormatAccessor)DefaultVertexFormat.f_85811_).getOffsets().getInt(index);
        return Float.intBitsToFloat(quad.m_111303_()[size]);
    }

    public static float yFromQuad(BakedQuad quad, int index) {
        int size = ((VertexFormatAccessor)DefaultVertexFormat.f_85811_).getOffsets().getInt(index);
        return Float.intBitsToFloat(quad.m_111303_()[size + 1]);
    }

    public static float zFromQuad(BakedQuad quad, int index) {
        int size = ((VertexFormatAccessor)DefaultVertexFormat.f_85811_).getOffsets().getInt(index);
        return Float.intBitsToFloat(quad.m_111303_()[size + 2]);
    }

    public static Vector3f normalFromQuad(BakedQuad quad, int index) {
        int size = ((VertexFormatAccessor)DefaultVertexFormat.f_85811_).getOffsets().getInt(index);
        int off = DefaultVertexFormat.f_85804_.m_86050_() + DefaultVertexFormat.f_85805_.m_86050_() + DefaultVertexFormat.f_85806_.m_86050_() + DefaultVertexFormat.f_85808_.m_86050_();
        float first = Float.intBitsToFloat(quad.m_111303_()[off]);
        float two = Float.intBitsToFloat(quad.m_111303_()[off + 1]);
        float three = Float.intBitsToFloat(quad.m_111303_()[off + 2]);
        return new Vector3f(first, two, three);
    }

    public static void registerBatteryPropertyOverrides(ItemBattery battery) {
        RenderHelper.registerProperty(battery, new ResourceLocation("antimatter", "battery"), (stack, world, living, some_int) -> {
            Optional handler = TesseractCapUtils.getEnergyHandlerItem((ItemStack)stack);
            return handler.map(h -> Float.valueOf((float)h.getEnergy() / (float)h.getCapacity())).orElse(Float.valueOf(1.0f)).floatValue();
        });
    }

    public static void registerProbePropertyOverrides(MaterialArmor armor) {
        RenderHelper.registerProperty((Item)armor, new ResourceLocation("antimatter", "probe"), (stack, world, living, some_int) -> {
            CompoundTag nbt = stack.m_41783_();
            return nbt != null && nbt.m_128441_("theoneprobe") && nbt.m_128471_("theoneprobe") ? 1.0f : 0.0f;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerProperty(Item item, ResourceLocation location, ClampedItemPropertyFunction function) {
        void var2_2;
        void var1_1;
        RenderHelperImpl.registerProperty(item, (ResourceLocation)var1_1, (ClampedItemPropertyFunction)var2_2);
    }

    public static void drawFluid(PoseStack mstack, Minecraft mc, int posX, int posY, int width, int height, int scaledAmount, FluidStack stack) {
        if (stack == null) {
            return;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return;
        }
        RenderSystem.m_69478_();
        TextureAtlasSprite fluidStillSprite = mc.m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(FluidPlatformUtils.getStillTexture((Fluid)fluid));
        int fluidColor = FluidPlatformUtils.getFluidColor((Fluid)fluid);
        RenderHelper.drawTiledSprite(mstack, mc, posX, posY, width, height, 16, 16, fluidColor, scaledAmount, fluidStillSprite);
        RenderSystem.m_69461_();
    }

    public static void drawTiledSprite(PoseStack stack, Minecraft mc, int posX, int posY, int tiledWidth, int tiledHeight, int texWidth, int texHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        float red = FastColor.ARGB32.m_13665_((int)color);
        float green = FastColor.ARGB32.m_13667_((int)color);
        float blue = FastColor.ARGB32.m_13669_((int)color);
        float alpha = FastColor.ARGB32.m_13655_((int)color);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.m_118414_().m_118330_());
        RenderSystem.m_157429_((float)(red / 255.0f), (float)(green / 255.0f), (float)(blue / 255.0f), (float)(alpha / 255.0f));
        Matrix4f matrix = stack.m_85850_().m_85861_();
        int xTileCount = tiledWidth / texWidth;
        int xRemainder = tiledWidth - xTileCount * texWidth;
        int yTileCount = scaledAmount / texHeight;
        int yRemainder = scaledAmount - yTileCount * texHeight;
        int yStart = posY + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : texWidth;
                int height = yTile == yTileCount ? yRemainder : texHeight;
                int x = posX + xTile * texWidth;
                int y = yStart - (yTile + 1) * texHeight;
                if (width <= 0 || height <= 0) continue;
                int maskTop = texHeight - height;
                int maskRight = texWidth - width;
                RenderHelper.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f, color);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTextureWithMasking(Matrix4f stack, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel, int color) {
        double uMin = textureSprite.m_118409_();
        double uMax = textureSprite.m_118410_();
        double vMin = textureSprite.m_118411_();
        double vMax = textureSprite.m_118412_();
        uMax -= (double)maskRight / 16.0 * (uMax - uMin);
        vMax -= (double)maskTop / 16.0 * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(stack, xCoord, yCoord + 16.0f, zLevel).m_7421_((float)uMin, (float)vMax).m_5752_();
        bufferBuilder.m_85982_(stack, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_((float)uMax, (float)vMax).m_5752_();
        bufferBuilder.m_85982_(stack, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_((float)uMax, (float)vMin).m_5752_();
        bufferBuilder.m_85982_(stack, xCoord, yCoord + (float)maskTop, zLevel).m_7421_((float)uMin, (float)vMin).m_5752_();
        tessellator.m_85914_();
    }

    public static void colorQuad(BakedQuad quad, int rgb) {
        RenderHelper.colorQuad(quad, DefaultVertexFormat.f_85811_.m_86017_(), ((VertexFormatAccessor)DefaultVertexFormat.f_85811_).getOffsets().getInt(1) / 4, rgb);
    }

    public static void colorQuad(BakedQuad quad, int size, int offset, int rgb) {
        int[] vertices = quad.m_111303_();
        for (int i = 0; i < 4; ++i) {
            vertices[offset + size * i] = RenderHelper.convertRGB2ABGR(rgb);
        }
    }

    public static int findPipeFront(PipeSize size, List<BakedQuad> quads, Direction side) {
        for (int i = 0; i < quads.size(); ++i) {
            int[] vertices;
            BakedQuad quad = quads.get(i);
            if (quad.m_111306_() != side || (vertices = quad.m_111303_()).length != DefaultVertexFormat.f_85811_.m_86017_() * 4) continue;
            float p1 = Float.intBitsToFloat(vertices[0]);
            float p2 = Float.intBitsToFloat(vertices[1]);
            float p3 = Float.intBitsToFloat(vertices[2]);
            int boff = DefaultVertexFormat.f_85811_.m_86017_() * 2;
            float p4 = Float.intBitsToFloat(vertices[boff]);
            float p5 = Float.intBitsToFloat(vertices[1 + boff]);
            float p6 = Float.intBitsToFloat(vertices[2 + boff]);
            float offset = 0.0625f * (float)size.ordinal();
            float a1 = 0.4375f - offset;
            float a2 = 0.5625f + offset;
            if (p1 != a1 && p2 != a1 && p3 != a1 && p4 != a1 && p5 != a1 && p6 != a1 || p1 != a2 && p2 != a2 && p3 != a2 && p4 != a2 && p5 != a2 && p6 != a2) continue;
            float d = p1 + p2 + p3 + p4 + p5 + p6;
            double ans = Math.abs((double)d - Math.floor(d));
            double anss = Math.abs((double)d - Math.ceil(d));
            if (!(ans < 0.01) && !(anss < 0.01)) continue;
            return i;
        }
        return -1;
    }

    public static int convertRGB2ABGR(int colour) {
        return 0xFF000000 | (colour & 0xFF) << 16 | (colour >> 8 & 0xFF) << 8 | colour >> 16 & 0xFF;
    }

    public static InteractionResult onDrawHighlight(Player player, LevelRenderer levelRenderer, Camera camera, HitResult target, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, Function<Block, Boolean> validator, BiFunction<Direction, BlockEntity, Boolean> getter) {
        float r;
        float g;
        Vec3 lookPos = player.m_20299_(partialTicks);
        Vec3 rotation = player.m_20252_(partialTicks);
        Vec3 realLookPos = lookPos.m_82520_(rotation.f_82479_ * INTERACT_DISTANCE, rotation.f_82480_ * INTERACT_DISTANCE, rotation.f_82481_ * INTERACT_DISTANCE);
        BlockHitResult result = player.m_20193_().m_45547_(new ClipContext(lookPos, realLookPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        BlockState state = player.m_20193_().m_8055_(result.m_82425_());
        if (!validator.apply(state.m_60734_()).booleanValue()) {
            return InteractionResult.PASS;
        }
        VoxelShape shape = player.m_20193_().m_8055_(result.m_82425_()).m_60651_((BlockGetter)player.m_20193_(), result.m_82425_(), CollisionContext.m_82750_((Entity)player));
        Vec3 viewPosition = camera.m_90583_();
        double viewX = viewPosition.f_82479_;
        double viewY = viewPosition.f_82480_;
        double viewZ = viewPosition.f_82481_;
        VertexConsumer builderLines = multiBufferSource.m_6299_((RenderType)RenderType.f_110371_);
        double modX = (double)result.m_82425_().m_123341_() - viewX;
        double modY = (double)result.m_82425_().m_123342_() - viewY;
        double modZ = (double)result.m_82425_().m_123343_() - viewZ;
        poseStack.m_85836_();
        long time = player.m_20193_().m_46467_();
        float b = g = (r = (float)(Math.abs(time % 126L - 63L) * 4L));
        float X = 1.0f;
        float Y = 1.0f;
        poseStack.m_85836_();
        LevelRendererAccessor.renderShape(poseStack, builderLines, shape, modX, modY, modZ, 0.0f, 0.0f, 0.0f, 0.4f);
        poseStack.m_85849_();
        switch (result.m_82434_()) {
            case UP: {
                poseStack.m_85837_(modX, modY + 1.0, modZ + 1.0);
                poseStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
                break;
            }
            case DOWN: {
                poseStack.m_85837_(modX, modY, modZ + 1.0);
                poseStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
                break;
            }
            case EAST: {
                poseStack.m_85837_(modX + 1.0, modY, modZ);
                poseStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -90.0f, true));
                break;
            }
            case WEST: {
                poseStack.m_85837_(modX, modY, modZ);
                poseStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -90.0f, true));
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(modX, modY, modZ + 1.0);
                break;
            }
            case NORTH: {
                poseStack.m_85837_(modX, modY, modZ);
            }
        }
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Matrix3f mat = poseStack.m_85850_().m_85864_();
        builderLines.m_85982_(matrix4f, INDENTATION_SIDE, 0.0f, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, INDENTATION_SIDE, 0.0f, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, INDENTATION_SIDE, Y, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, INDENTATION_SIDE, Y, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, 0.0f, 0.0f + INDENTATION_SIDE, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, 0.0f, 0.0f + INDENTATION_SIDE, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, X, 0.0f + INDENTATION_SIDE, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, X, 0.0f + INDENTATION_SIDE, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, X - INDENTATION_SIDE, 0.0f, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, X - INDENTATION_SIDE, 0.0f, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, X - INDENTATION_SIDE, Y, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, X - INDENTATION_SIDE, Y, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, 0.0f, Y - INDENTATION_SIDE, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, 0.0f, Y - INDENTATION_SIDE, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, X, Y - INDENTATION_SIDE, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, X, Y - INDENTATION_SIDE, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, 0.0f, 0.0f, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, 0.0f, Y, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, 0.0f, Y, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, 0.0f, 0.0f, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, X, 0.0f, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, X, 0.0f, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, X, Y, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, X, Y, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, X, 0.0f, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, X, 0.0f, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, X, Y, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, X, Y, 0.0f).m_5752_();
        builderLines.m_85982_(matrix4f, 0.0f, Y, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(mat, 0.0f, Y, 0.0f).m_5752_();
        BlockEntity tile = player.m_20193_().m_7702_(result.m_82425_());
        if (tile != null) {
            boolean down;
            boolean up;
            boolean left;
            boolean right;
            byte sides = 0;
            Direction dir = result.m_82434_();
            for (Direction d : Ref.DIRS) {
                if (!getter.apply(d, tile).booleanValue()) continue;
                sides = (byte)(sides | 1 << d.m_122411_());
            }
            boolean back = Connectivity.has((byte)sides, (int)dir.m_122424_().m_122411_());
            boolean front = Connectivity.has((byte)sides, (int)dir.m_122411_());
            if (dir.m_122434_().m_122478_()) {
                if (dir == Direction.UP) {
                    right = Connectivity.has((byte)sides, (int)4);
                    left = Connectivity.has((byte)sides, (int)5);
                    up = Connectivity.has((byte)sides, (int)2);
                    down = Connectivity.has((byte)sides, (int)3);
                } else {
                    right = Connectivity.has((byte)sides, (int)5);
                    left = Connectivity.has((byte)sides, (int)4);
                    up = Connectivity.has((byte)sides, (int)3);
                    down = Connectivity.has((byte)sides, (int)2);
                }
            } else {
                if (dir == Direction.EAST || dir == Direction.NORTH) {
                    right = Connectivity.has((byte)sides, (int)dir.m_122428_().m_122411_());
                    left = Connectivity.has((byte)sides, (int)dir.m_122427_().m_122411_());
                } else {
                    right = Connectivity.has((byte)sides, (int)dir.m_122427_().m_122411_());
                    left = Connectivity.has((byte)sides, (int)dir.m_122428_().m_122411_());
                }
                up = Connectivity.has((byte)sides, (int)1);
                down = Connectivity.has((byte)sides, (int)0);
            }
            if (back) {
                RenderHelper.drawX(builderLines, matrix4f, mat, 0.0f, 0.0f, INDENTATION_SIDE, INDENTATION_SIDE, r, g, b);
                RenderHelper.drawX(builderLines, matrix4f, mat, X, 0.0f, X - INDENTATION_SIDE, INDENTATION_SIDE, r, g, b);
                RenderHelper.drawX(builderLines, matrix4f, mat, X, Y, X - INDENTATION_SIDE, Y - INDENTATION_SIDE, r, g, b);
                RenderHelper.drawX(builderLines, matrix4f, mat, 0.0f, Y, INDENTATION_SIDE, Y - INDENTATION_SIDE, r, g, b);
            }
            if (left) {
                RenderHelper.drawX(builderLines, matrix4f, mat, X, INDENTATION_SIDE, X - INDENTATION_SIDE, Y - INDENTATION_SIDE, r, g, b);
            }
            if (right) {
                RenderHelper.drawX(builderLines, matrix4f, mat, 0.0f, INDENTATION_SIDE, INDENTATION_SIDE, Y - INDENTATION_SIDE, r, g, b);
            }
            if (up) {
                RenderHelper.drawX(builderLines, matrix4f, mat, INDENTATION_SIDE, Y - INDENTATION_SIDE, X - INDENTATION_SIDE, Y, r, g, b);
            }
            if (down) {
                RenderHelper.drawX(builderLines, matrix4f, mat, INDENTATION_SIDE, 0.0f, X - INDENTATION_SIDE, INDENTATION_SIDE, r, g, b);
            }
            if (front) {
                RenderHelper.drawX(builderLines, matrix4f, mat, INDENTATION_SIDE, INDENTATION_SIDE, X - INDENTATION_SIDE, Y - INDENTATION_SIDE, r, g, b);
            }
        }
        poseStack.m_85849_();
        return InteractionResult.SUCCESS;
    }

    public static Transformation faceRotation(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return RenderHelper.faceRotation((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_));
        }
        return RenderHelper.faceRotation((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
    }

    public static Transformation faceRotation(Direction side) {
        Quaternion quat = side.m_122434_() != Direction.Axis.Y ? Vector3f.f_122225_.m_122240_(-side.m_122435_()) : Vector3f.f_122223_.m_122240_((float)(-side.m_122436_().m_123342_()) * 90.0f);
        return new Transformation(null, quat, null, null);
    }

    private static void drawX(VertexConsumer builder, Matrix4f matrix, Matrix3f normal, float x1, float y1, float x2, float y2, float r, float g, float b) {
        builder.m_85982_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(normal, x1, y1, 0.0f).m_5752_();
        builder.m_85982_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(normal, x2, y2, 0.0f).m_5752_();
        builder.m_85982_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(normal, x2, y1, 0.0f).m_5752_();
        builder.m_85982_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, 0.4f).m_85977_(normal, x1, y2, 0.0f).m_5752_();
    }

    public static void renderCubeFace(VertexConsumer buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a) {
        buffer.m_5483_(minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, maxY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, minY, minZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, minY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(maxX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(minX, maxY, maxZ).m_85950_(r, g, b, a).m_5752_();
    }
}

