/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client;

import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.client.baked.CoverBakedModel;
import muramasa.antimatter.client.forge.ModelUtilsImpl;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class ModelUtils {
    public static Transformation transform(Direction side) {
        switch (side) {
            case DOWN: {
                return new Transformation(null, new Quaternion(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 90.0f, true)), null, null);
            }
            case UP: {
                return new Transformation(null, new Quaternion(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true)), null, null);
            }
            case NORTH: {
                return Transformation.m_121093_();
            }
            case SOUTH: {
                return new Transformation(null, new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 180.0f, true), null, null);
            }
            case WEST: {
                return new Transformation(null, new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true), null, null);
            }
            case EAST: {
                return new Transformation(null, new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -90.0f, true), null, null);
            }
        }
        throw new RuntimeException("Invalid direction/null sent to transform.");
    }

    public static UnbakedModel getMissingModel() {
        return ModelUtils.getModelBakery().m_119341_((ResourceLocation)new ModelResourceLocation("builtin/missing", "missing"));
    }

    public static UnbakedModel getModel(ResourceLocation resourceLocation) {
        return ModelUtils.getModelBakery().m_119341_(resourceLocation);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SimpleBakedModel.Builder createSimpleModelBuilder(boolean smoothLighting, boolean sideLit, boolean isShadedInGui, ItemTransforms transforms, ItemOverrides overrides) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return ModelUtilsImpl.createSimpleModelBuilder(smoothLighting, (boolean)var1_1, (boolean)var2_2, (ItemTransforms)var3_3, (ItemOverrides)var4_4);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Function<ResourceLocation, UnbakedModel> getDefaultModelGetter() {
        return ModelUtilsImpl.getDefaultModelGetter();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Function<Material, TextureAtlasSprite> getDefaultTextureGetter() {
        return ModelUtilsImpl.getDefaultTextureGetter();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ModelBakery getModelBakery() {
        return ModelUtilsImpl.getModelBakery();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setLightData(BakedQuad model, int light) {
        void var1_1;
        ModelUtilsImpl.setLightData(model, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<BakedQuad> getQuadsFromBaked(BakedModel model, BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return ModelUtilsImpl.getQuadsFromBaked(model, (BlockState)var1_1, (Direction)var2_2, (Random)var3_3, (BlockAndTintGetter)var4_4, (BlockPos)var5_5);
    }

    public static List<BakedQuad> getQuadsFromBakedCover(BakedModel model, BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, Predicate<Map.Entry<String, BakedModel>> coverPredicate) {
        if (model instanceof CoverBakedModel) {
            CoverBakedModel coverBakedModel = (CoverBakedModel)model;
            return coverBakedModel.getBlockQuads(state, side, rand, level, pos, coverPredicate);
        }
        return ModelUtils.getQuadsFromBaked(model, state, side, rand, level, pos);
    }

    public static BakedModel getBakedFromQuads(BlockModel model, List<BakedQuad> quads, Function<Material, TextureAtlasSprite> getter) {
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, ItemOverrides.f_111734_, true).m_119528_(getter.apply(model.m_111480_("particle")));
        quads.forEach(arg_0 -> ((SimpleBakedModel.Builder)builder).m_119526_(arg_0));
        return builder.m_119533_();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BakedModel getBakedFromModel(BlockModel model, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ResourceLocation loc) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return ModelUtilsImpl.getBakedFromModel(model, (ModelBakery)var1_1, (Function<Material, TextureAtlasSprite>)var2_2, (ModelState)var3_3, (ResourceLocation)var4_4);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BakedModel getSimpleBakedModel(BakedModel baked) {
        return ModelUtilsImpl.getSimpleBakedModel(baked);
    }

    public static BakedModel getBaked(ResourceLocation loc) {
        return (BakedModel)ModelUtils.getModelBakery().m_119251_().get(loc);
    }

    public static BakedModel getBakedFromState(BlockState state) {
        return Minecraft.m_91087_().m_91304_().m_119422_(BlockModelShaper.m_110895_((BlockState)state));
    }

    public static BakedModel getBakedFromItem(Item item) {
        return Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(new ModelResourceLocation(AntimatterPlatformUtils.getIdFromItem(item), "inventory"));
    }

    public static TextureAtlasSprite getSprite(ResourceLocation loc) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(loc);
    }

    public static Material getBlockMaterial(ResourceLocation loc) {
        return new Material(InventoryMenu.f_39692_, loc);
    }

    public static List<BakedQuad> trans(List<BakedQuad> quads, Vector3f rotationL, Vector3f rotationR) {
        Quaternion rotL = rotationL == null ? null : ModelUtils.quatFromXYZ(rotationL, true);
        Quaternion rotR = rotationR == null ? null : ModelUtils.quatFromXYZ(rotationR, true);
        return ModelUtils.trans(quads, new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), rotL, null, rotR));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Quaternion quatFromXYZ(Vector3f xyz, boolean degrees) {
        void var1_1;
        return ModelUtilsImpl.quatFromXYZ(xyz, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<BakedQuad> trans(List<BakedQuad> quads, Transformation transform) {
        void var1_1;
        return ModelUtilsImpl.trans(quads, (Transformation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setRenderLayer(Block block, RenderType renderType) {
        void var1_1;
        ModelUtilsImpl.setRenderLayer(block, (RenderType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setRenderLayer(Fluid fluid, RenderType renderType) {
        void var1_1;
        ModelUtilsImpl.setRenderLayer(fluid, (RenderType)var1_1);
    }
}

