/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import muramasa.antimatter.client.ModelUtils;
import muramasa.antimatter.client.SimpleModelState;
import muramasa.antimatter.client.model.IModelConfiguration;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;

public interface IAntimatterModel {
    default public ModelState getModelTransform(ModelState base, int[] rots) {
        if (rots == null || rots.length != 3 || rots[0] == 0 && rots[1] == 0 && rots[2] == 0) {
            return base;
        }
        return new SimpleModelState(new Transformation(null, new Quaternion((float)rots[0], (float)rots[1], (float)rots[2], true), null, null));
    }

    public BakedModel bakeModel(ModelBakery var1, Function<Material, TextureAtlasSprite> var2, ModelState var3, ResourceLocation var4);

    public Collection<Material> getMaterials(IModelConfiguration var1, Function<ResourceLocation, UnbakedModel> var2, Set<Pair<String, String>> var3);

    default public BakedModel bakeModel(IModelConfiguration configuration, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
        return this.bakeModel(bakery, getter, transform, loc);
    }

    default public BakedModel bake(IModelConfiguration configuration, ModelBakery bakery, Function<Material, TextureAtlasSprite> getter, ModelState transform, ItemOverrides overrides, ResourceLocation loc) {
        try {
            return this.bakeModel(configuration, bakery, getter, transform, overrides, loc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ModelUtils.getMissingModel().m_7611_(bakery, getter, transform, loc);
        }
    }
}

