/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Supplier;
import muramasa.antimatter.client.baked.PipeBakedModel;
import muramasa.antimatter.client.model.loader.DefaultModelLoader;
import muramasa.antimatter.client.model.loader.DynamicModelLoader;
import muramasa.antimatter.client.model.loader.MachineModelLoader;
import muramasa.antimatter.client.model.loader.PipeModelLoader;
import muramasa.antimatter.client.model.loader.ProxyModelLoader;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.registration.IModelProvider;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class AntimatterModelManager {
    private static final Object2ObjectOpenHashMap<String, Supplier<Int2ObjectOpenHashMap<BakedModel[]>>> STATIC_CONFIG_MAPS = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<ResourceLocation, IItemProviderOverride> ITEM_OVERRIDES = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<ResourceLocation, IBlockProviderOverride> BLOCK_OVERRIDES = new Object2ObjectOpenHashMap();
    public static final ResourceLocation LOADER_MAIN = new ResourceLocation("antimatter", "main");
    public static final ResourceLocation LOADER_COVER = new ResourceLocation("antimatter", "cover");
    public static final ResourceLocation LOADER_MACHINE_SIDE = new ResourceLocation("antimatter", "machine_side");
    public static final ResourceLocation LOADER_DYNAMIC = new ResourceLocation("antimatter", "dynamic");
    public static final ResourceLocation LOADER_MACHINE = new ResourceLocation("antimatter", "machine");
    public static final ResourceLocation LOADER_PIPE = new ResourceLocation("antimatter", "pipe");
    public static final ResourceLocation LOADER_PROXY = new ResourceLocation("antimatter", "proxy");

    public static void init() {
        AntimatterModelManager.registerStaticConfigMap("pipe", () -> PipeBakedModel.CONFIGS);
        new DefaultModelLoader(LOADER_MAIN);
        new MachineModelLoader.CoverModelLoader(LOADER_COVER);
        new MachineModelLoader.SideModelLoader(LOADER_MACHINE_SIDE);
        new DynamicModelLoader(LOADER_DYNAMIC);
        new MachineModelLoader(LOADER_MACHINE);
        new PipeModelLoader(LOADER_PIPE);
        new ProxyModelLoader(LOADER_PROXY);
    }

    public static void registerStaticConfigMap(String staticMapId, Supplier<Int2ObjectOpenHashMap<BakedModel[]>> configMapSupplier) {
        STATIC_CONFIG_MAPS.put((Object)staticMapId, configMapSupplier);
    }

    public static Int2ObjectOpenHashMap<BakedModel[]> getStaticConfigMap(String staticMapId) {
        return (Int2ObjectOpenHashMap)((Supplier)STATIC_CONFIG_MAPS.getOrDefault((Object)staticMapId, Int2ObjectOpenHashMap::new)).get();
    }

    public static void put(Item item, IItemProviderOverride override) {
        ITEM_OVERRIDES.put((Object)AntimatterPlatformUtils.getIdFromItem(item), (Object)override);
    }

    public static void put(Block block, IBlockProviderOverride override) {
        BLOCK_OVERRIDES.put((Object)AntimatterPlatformUtils.getIdFromBlock(block), (Object)override);
    }

    public static void onItemModelBuild(ItemLike item, AntimatterItemModelProvider prov) {
        IItemProviderOverride override = (IItemProviderOverride)ITEM_OVERRIDES.get((Object)AntimatterPlatformUtils.getIdFromItem(item.m_5456_()));
        if (override != null) {
            override.apply((ItemLike)item.m_5456_(), prov);
        } else if (item instanceof IModelProvider) {
            ((IModelProvider)item).onItemModelBuild(item, prov);
        }
    }

    public static void onBlockModelBuild(Block block, AntimatterBlockStateProvider prov) {
        IBlockProviderOverride override = (IBlockProviderOverride)BLOCK_OVERRIDES.get((Object)AntimatterPlatformUtils.getIdFromBlock(block));
        if (override != null) {
            override.apply(block, prov, prov.getBuilder(block));
        } else if (block instanceof IModelProvider) {
            ((IModelProvider)block).onBlockModelBuild(block, prov);
        }
    }

    public static interface IItemProviderOverride {
        public void apply(ItemLike var1, AntimatterItemModelProvider var2);
    }

    public static interface IBlockProviderOverride {
        public void apply(Block var1, AntimatterBlockStateProvider var2, AntimatterBlockModelBuilder var3);
    }
}

