/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.rf;

import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import muramasa.antimatter.capability.rf.RFSnapshot;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import tesseract.api.rf.IRFNode;

public class RFHandler
implements IRFNode {
    protected final long capacity;
    protected long energy;
    protected long maxIn;
    protected long maxOut;

    public RFHandler(long energy, long capacity, int maxIn, int maxOut) {
        this.energy = energy;
        this.capacity = capacity;
        this.maxIn = maxIn;
        this.maxOut = maxOut;
    }

    public void setMaxOutput(long maxOutput) {
        this.maxOut = maxOutput;
    }

    public void setMaxInput(long maxInput) {
        this.maxIn = maxInput;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
    }

    public long extractEnergy(long maxAmount, boolean simulate) {
        long maxExtract = Math.min(maxAmount, this.energy);
        if (!simulate) {
            this.energy -= maxExtract;
        }
        return maxExtract;
    }

    public long insertEnergy(long maxAmount, boolean simulate) {
        long maxInsert = Mth.m_14053_((long)maxAmount, (long)0L, (long)(this.capacity - this.energy));
        if (!simulate) {
            this.energy += maxInsert;
        }
        return maxInsert;
    }

    public long getStoredEnergy() {
        return this.energy;
    }

    public long getMaxCapacity() {
        return this.capacity;
    }

    public long maxInsert() {
        return this.maxIn;
    }

    public long maxExtract() {
        return this.maxOut;
    }

    public boolean allowsInsertion() {
        return this.maxIn > 0L;
    }

    public boolean canInput(Direction direction) {
        return this.allowsInsertion();
    }

    public boolean canOutput(Direction direction) {
        return this.allowsExtraction();
    }

    public boolean allowsExtraction() {
        return this.maxOut > 0L;
    }

    public EnergySnapshot createSnapshot() {
        return new RFSnapshot(this);
    }

    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128356_("me", this.energy);
        tag.m_128356_("vi", this.maxIn);
        tag.m_128356_("vo", this.maxOut);
        return tag;
    }

    public void deserialize(CompoundTag nbt) {
        this.energy = nbt.m_128454_("me");
        this.maxIn = nbt.m_128454_("vi");
        this.maxOut = nbt.m_128454_("vo");
    }

    public void m_6211_() {
        this.energy = 0L;
    }
}

