/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import muramasa.antimatter.capability.item.ITrackedHandler;
import muramasa.antimatter.capability.item.MultiTrackedItemHandler;
import muramasa.antimatter.capability.machine.MachineItemHandler;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MultiMachineItemHandler<T extends TileEntityMultiMachine<T>>
extends MachineItemHandler<T> {
    Optional<ITrackedHandler> inputs = Optional.empty();
    Optional<ITrackedHandler> outputs = Optional.empty();

    public MultiMachineItemHandler(T tile) {
        super(tile);
    }

    @Override
    public boolean canOutputsFit(ItemStack[] a) {
        return this.outputs.isPresent() && a != null && this.outputs.get().getSlots() >= a.length;
    }

    @Override
    public ITrackedHandler getInputHandler() {
        return this.inputs.orElseGet(this::calculateInputs);
    }

    public void invalidate() {
        this.inputs = Optional.empty();
        this.outputs = Optional.empty();
    }

    public void onStructureBuild() {
        this.inputs = Optional.of(this.calculateInputs());
        this.outputs = Optional.of(this.calculateOutputs());
    }

    private ITrackedHandler calculateInputs() {
        List<IItemHandlerModifiable> handlers = ((TileEntityMultiMachine)this.tile).getComponents("hatch_item_input").stream().filter(t -> t.getItemHandler().isPresent()).map(t -> t.getItemHandler().get().getInputHandler()).collect(Collectors.toList());
        handlers.add(super.getInputHandler());
        return new MultiTrackedItemHandler(handlers.toArray(new IItemHandlerModifiable[0]));
    }

    private ITrackedHandler calculateOutputs() {
        List<IItemHandlerModifiable> handlers = ((TileEntityMultiMachine)this.tile).getComponents("hatch_item_output").stream().filter(t -> t.getItemHandler().isPresent()).map(t -> t.getItemHandler().get().getOutputHandler()).collect(Collectors.toList());
        handlers.add(super.getOutputHandler());
        return new MultiTrackedItemHandler(handlers.toArray(new IItemHandlerModifiable[0]));
    }

    @Override
    public ITrackedHandler getOutputHandler() {
        return this.outputs.orElseGet(this::calculateOutputs);
    }
}

