/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.FluidHandler;
import muramasa.antimatter.capability.IComponentHandler;
import muramasa.antimatter.capability.fluid.FluidTanks;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import net.minecraftforge.fluids.FluidStack;

public class MultiMachineFluidHandler<T extends TileEntityMultiMachine<T>>
extends MachineFluidHandler<T> {
    MachineFluidHandler<?>[] inputs = new MachineFluidHandler[0];
    MachineFluidHandler<?>[] outputs = new MachineFluidHandler[0];
    protected Int2ObjectMap<MachineFluidHandler<?>> INPUT_TO_HANDLER = new Int2ObjectOpenHashMap();
    protected Object2IntMap<MachineFluidHandler<?>> INPUT_START = new Object2IntOpenHashMap();
    protected int INPUT_END;
    protected Int2ObjectMap<MachineFluidHandler<?>> OUTPUT_TO_HANDLER = new Int2ObjectOpenHashMap();
    protected Object2IntMap<MachineFluidHandler<?>> OUTPUT_START = new Object2IntOpenHashMap();
    protected final EnumMap<FluidHandler.FluidDirection, FluidTanks> tanks = new EnumMap(FluidHandler.FluidDirection.class);

    public MultiMachineFluidHandler(T tile) {
        super(tile);
    }

    @Override
    public boolean canOutputsFit(FluidStack[] outputs) {
        return outputs != null && this.outputs != null && this.outputs.length >= outputs.length;
    }

    protected void cacheInputs() {
        this.inputs = (MachineFluidHandler[])((TileEntityMultiMachine)this.tile).getComponents("hatch_fluid_input").stream().map(IComponentHandler::getFluidHandler).map(Optional::get).toArray(MachineFluidHandler[]::new);
        this.INPUT_TO_HANDLER.clear();
        this.INPUT_START.clear();
        int i = 0;
        for (MachineFluidHandler<?> input : this.inputs) {
            for (int j = 0; j < input.getTanks(); ++j) {
                this.INPUT_TO_HANDLER.put(j + i, input);
                if (j != 0) continue;
                this.INPUT_START.put(input, i);
            }
            i += input.getTanks();
        }
        this.INPUT_END = i;
    }

    protected void cacheOutputs() {
        this.outputs = (MachineFluidHandler[])((TileEntityMultiMachine)this.tile).getComponents("hatch_fluid_output").stream().map(IComponentHandler::getFluidHandler).map(Optional::get).toArray(MachineFluidHandler[]::new);
        this.OUTPUT_TO_HANDLER.clear();
        this.OUTPUT_START.clear();
        int i = 0;
        for (MachineFluidHandler<?> output : this.outputs) {
            for (int j = 0; j < output.getTanks(); ++j) {
                this.OUTPUT_TO_HANDLER.put(j + i, output);
                if (j != 0) continue;
                this.OUTPUT_START.put(output, i);
            }
            i += output.getTanks();
        }
    }

    @Override
    @Nullable
    public FluidTanks getInputTanks() {
        return new FluidTanks(Arrays.stream(this.inputs).filter(t -> t.getInputTanks() != null).flatMap(t -> Arrays.stream(t.getInputTanks().getBackingTanks())).collect(Collectors.toList()));
    }

    @Override
    @Nullable
    public FluidTanks getOutputTanks() {
        return new FluidTanks(Arrays.stream(this.outputs).filter(t -> t.getOutputTanks() != null).flatMap(t -> Arrays.stream(t.getOutputTanks().getBackingTanks())).collect(Collectors.toList()));
    }

    @Override
    public int getTanks() {
        return Arrays.stream(this.inputs).mapToInt(FluidHandler::getTanks).sum() + Arrays.stream(this.outputs).mapToInt(FluidHandler::getTanks).sum();
    }

    @Override
    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < this.INPUT_END) {
            return ((MachineFluidHandler)this.INPUT_TO_HANDLER.get(tank)).getFluidInTank(tank - this.INPUT_START.get(this.INPUT_TO_HANDLER.get(tank)));
        }
        return ((MachineFluidHandler)this.OUTPUT_TO_HANDLER.get(tank)).getFluidInTank(tank - this.OUTPUT_START.get(this.OUTPUT_TO_HANDLER.get(tank)));
    }

    public void invalidate() {
        this.inputs = new MachineFluidHandler[0];
        this.outputs = new MachineFluidHandler[0];
    }

    public void onStructureBuild() {
        this.cacheInputs();
        this.cacheOutputs();
    }
}

