/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import java.util.Arrays;
import muramasa.antimatter.capability.machine.MachineEnergyHandler;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IGTNode;

public class MultiMachineEnergyHandler<T extends TileEntityMultiMachine<T>>
extends MachineEnergyHandler<T> {
    protected MachineEnergyHandler<?>[] inputs;
    protected MachineEnergyHandler<?>[] outputs;
    protected long cachedCapacity;

    public MultiMachineEnergyHandler(T tile, long energy, long capacity, int voltage_in, int voltage_out, int amperage_in, int amperage_out) {
        super(tile, energy, capacity, voltage_in, voltage_out, amperage_in, amperage_out);
    }

    public MultiMachineEnergyHandler(T tile) {
        super(tile, 0L, 0L, 0, 0, 0, 0);
    }

    public void onStructureBuild() {
        this.cacheInputs();
        this.cacheOutputs();
        IEnergyHandler handler = this.anyHandler();
        if (handler != null) {
            this.voltageIn = handler.getInputVoltage();
            this.voltageOut = handler.getOutputVoltage();
        }
        this.cachedCapacity = super.getCapacity() + Arrays.stream(this.inputs).mapToLong(IGTNode::getCapacity).sum() + Arrays.stream(this.outputs).mapToLong(IGTNode::getCapacity).sum();
    }

    private void cacheInputs() {
        this.inputs = (MachineEnergyHandler[])((TileEntityMultiMachine)this.tile).getComponents("hatch_energy").stream().filter(t -> t.getEnergyHandler().isPresent()).map(t -> t.getEnergyHandler().get()).toArray(MachineEnergyHandler[]::new);
    }

    private void cacheOutputs() {
        this.outputs = (MachineEnergyHandler[])((TileEntityMultiMachine)this.tile).getComponents("hatch_dynamo").stream().filter(t -> t.getEnergyHandler().isPresent()).map(t -> t.getEnergyHandler().get()).toArray(MachineEnergyHandler[]::new);
    }

    private IEnergyHandler anyHandler() {
        if (this.inputs != null && this.inputs.length > 0) {
            return this.inputs[0];
        }
        if (this.outputs != null && this.outputs.length > 0) {
            return this.outputs[0];
        }
        return null;
    }

    public void invalidate() {
        this.cachedCapacity = super.getCapacity();
        this.inputs = null;
        this.outputs = null;
    }

    @Override
    public long getEnergy() {
        return super.getEnergy() + (this.inputs == null ? 0L : Arrays.stream(this.inputs).mapToLong(IGTNode::getEnergy).sum()) + (this.outputs == null ? 0L : Arrays.stream(this.outputs).mapToLong(IGTNode::getEnergy).sum());
    }

    @Override
    public long getCapacity() {
        return this.cachedCapacity;
    }

    @Override
    public boolean canOutput() {
        return false;
    }

    @Override
    public boolean canInput() {
        return false;
    }

    @Override
    public boolean extractEnergy(GTTransaction.TransferData data) {
        boolean ok = super.extractEnergy(data);
        if (data.transaction.mode == GTTransaction.Mode.INTERNAL) {
            for (MachineEnergyHandler<?> handler : this.inputs) {
                ok |= handler.extractEnergy(data);
            }
        }
        return ok;
    }

    @Override
    public boolean addEnergy(GTTransaction.TransferData data) {
        boolean ok = super.addEnergy(data);
        if (data.transaction.mode == GTTransaction.Mode.INTERNAL) {
            for (MachineEnergyHandler<?> handler : this.outputs) {
                ok |= handler.addEnergy(data);
            }
        }
        return ok;
    }

    public boolean insert(GTTransaction transaction) {
        return super.insert(transaction);
    }

    public Tier getAccumulatedPower() {
        Tier tier;
        if (this.inputs == null) {
            return Tier.ULV;
        }
        long voltage = Arrays.stream(this.inputs).mapToLong(t -> t.getInputVoltage() * t.getInputAmperage()).sum();
        return voltage >= (long)(tier = Tier.getTier((int)voltage)).getVoltage() ? tier : Tier.getTier((int)(voltage >> 2));
    }
}

