/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.capability.IMachineHandler;
import muramasa.antimatter.capability.item.TrackedItemHandler;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.gui.SlotType;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.event.MachineEvent;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.IRecipeValidator;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tile.TileEntityTickable;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import tesseract.api.gt.GTTransaction;

public class MachineRecipeHandler<T extends TileEntityMachine<T>>
implements IMachineHandler,
Dispatch.Sided<MachineRecipeHandler<?>> {
    protected final T tile;
    protected final boolean generator;
    protected IRecipe lastRecipe = null;
    protected IRecipe activeRecipe;
    protected boolean consumedResources;
    protected int currentProgress;
    protected int maxProgress;
    protected int overclock;
    static final int WAIT_TIME = 400;
    static final int WAIT_TIME_POWER_LOSS = 100;
    static final int WAIT_TIME_OUTPUT_FULL = 20;
    protected int tickTimer = 0;
    private boolean tickingRecipe = false;
    protected List<ItemStack> itemInputs = Collections.emptyList();
    protected List<FluidStack> fluidInputs = Collections.emptyList();

    public MachineRecipeHandler(T tile) {
        this.tile = tile;
        this.generator = ((TileEntityMachine)tile).getMachineType().has(MachineFlag.GENERATOR);
    }

    public void getInfo(List<String> builder) {
        if (this.activeRecipe != null) {
            if (((TileEntityMachine)this.tile).getMachineState() != MachineState.ACTIVE) {
                builder.add("Active recipe but not running");
            }
            builder.add("Progress: " + this.currentProgress + "/" + this.maxProgress);
        } else {
            builder.add("No recipe active");
        }
    }

    public boolean hasRecipe() {
        return this.activeRecipe != null;
    }

    public float getClientProgress() {
        return (float)this.currentProgress / (float)this.maxProgress;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public void init() {
        this.checkRecipe();
    }

    public void resetProgress() {
        this.currentProgress = 0;
    }

    public void onServerUpdate() {
        if (this.tickingRecipe) {
            return;
        }
        if (this.tickTimer > 0) {
            if (((TileEntityMachine)this.tile).getMachineState() == MachineState.IDLE) {
                this.tickTimer = 0;
            } else {
                --this.tickTimer;
                if (this.tickTimer > 0) {
                    return;
                }
            }
        }
        if (((TileEntityMachine)this.tile).getMachineState() == MachineState.POWER_LOSS && this.activeRecipe != null) {
            ((TileEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
            this.tickTimer = 0;
        }
        if (((TileEntityMachine)this.tile).getMachineState() == MachineState.OUTPUT_FULL && this.canOutput()) {
            ((TileEntityMachine)this.tile).setMachineState(this.recipeFinish());
            return;
        }
        if (this.activeRecipe == null) {
            return;
        }
        this.tickingRecipe = true;
        switch (((TileEntityMachine)this.tile).getMachineState()) {
            case ACTIVE: {
                MachineState state = this.tickRecipe();
                ((TileEntityMachine)this.tile).setMachineState(state);
                break;
            }
            case NO_POWER: {
                MachineState state = this.tickRecipe();
                if (state != MachineState.ACTIVE) {
                    ((TileEntityMachine)this.tile).setMachineState(((TileEntityMachine)this.tile).getDefaultMachineState());
                    break;
                }
                ((TileEntityMachine)this.tile).setMachineState(state);
                break;
            }
        }
        this.tickingRecipe = false;
    }

    public IRecipe findRecipe() {
        IRecipeMap map;
        if (this.lastRecipe != null) {
            this.activeRecipe = this.lastRecipe;
            if (this.canRecipeContinue()) {
                this.activeRecipe = null;
                return this.lastRecipe;
            }
            this.activeRecipe = null;
        }
        return (map = ((TileEntityMachine)this.tile).getMachineType().getRecipeMap()) != null ? map.find(((TileEntityMachine)this.tile).itemHandler, ((TileEntityMachine)this.tile).fluidHandler, ((TileEntityMachine)this.tile).getMachineTier(), this::validateRecipe) : null;
    }

    protected IRecipe cachedRecipe() {
        if (this.lastRecipe != null) {
            if (!this.lastRecipe.isValid()) {
                this.lastRecipe = null;
                return null;
            }
            IRecipe old = this.activeRecipe;
            this.activeRecipe = this.lastRecipe;
            if (this.canRecipeContinue()) {
                this.activeRecipe = old;
                return this.lastRecipe;
            }
            this.activeRecipe = old;
        }
        return null;
    }

    public int getOverclock() {
        if (this.activeRecipe == null) {
            return 0;
        }
        int oc = 0;
        if (this.activeRecipe.getPower() > 0L && (long)((TileEntityMachine)this.tile).getPowerLevel().getVoltage() > this.activeRecipe.getPower()) {
            long voltage = this.activeRecipe.getPower();
            int tier = Utils.getVoltageTier(voltage);
            int tempoverclock = ((TileEntityMachine)this.tile).getPowerLevel().getVoltage() / Ref.V[tier];
            while (tempoverclock > 1) {
                tempoverclock >>= 2;
                ++oc;
            }
        }
        return oc;
    }

    public long getPower() {
        if (this.activeRecipe == null) {
            return 0L;
        }
        if (this.overclock == 0 || ((TileEntityMachine)this.tile).has(MachineFlag.RF)) {
            return this.activeRecipe.getPower();
        }
        return this.activeRecipe.getPower() * (1L << this.overclock) * (1L << this.overclock);
    }

    protected void calculateDurations() {
        this.maxProgress = this.activeRecipe.getDuration();
        if (!this.generator && !((TileEntityMachine)this.tile).has(MachineFlag.RF)) {
            this.overclock = this.getOverclock();
            this.maxProgress = Math.max(1, this.maxProgress >> this.overclock);
        }
    }

    protected void activateRecipe(boolean reset) {
        this.consumedResources = false;
        this.tickTimer = 0;
        if (reset) {
            this.currentProgress = 0;
        }
        this.lastRecipe = this.activeRecipe;
    }

    protected void addOutputs() {
        if (this.activeRecipe.hasOutputItems()) {
            ((TileEntityMachine)this.tile).itemHandler.ifPresent(h -> {
                ItemStack[] out = this.activeRecipe.getOutputItems(true);
                if (h.canOutputsFit(out)) {
                    h.addOutputs(out);
                } else {
                    h.addOutputs(this.activeRecipe.getFlatOutputItems());
                }
                ((TileEntityMachine)this.tile).onMachineEvent(MachineEvent.ITEMS_OUTPUTTED, new Object[0]);
            });
        }
        if (this.activeRecipe.hasOutputFluids()) {
            ((TileEntityMachine)this.tile).fluidHandler.ifPresent(h -> {
                h.addOutputs(this.activeRecipe.getOutputFluids());
                ((TileEntityMachine)this.tile).onMachineEvent(MachineEvent.FLUIDS_OUTPUTTED, new Object[0]);
            });
        }
    }

    protected MachineState recipeFinish() {
        this.tickTimer = 0;
        this.addOutputs();
        this.itemInputs = new ObjectArrayList();
        this.fluidInputs = new ObjectArrayList();
        if (this.generator) {
            this.currentProgress = 0;
            return MachineState.ACTIVE;
        }
        if (!this.canRecipeContinue()) {
            this.resetRecipe();
            this.checkRecipe();
            return this.activeRecipe != null ? MachineState.ACTIVE : ((TileEntityMachine)this.tile).getDefaultMachineState();
        }
        this.calculateDurations();
        this.activateRecipe(true);
        return MachineState.ACTIVE;
    }

    protected MachineState tickRecipe() {
        if (this.activeRecipe == null) {
            System.out.println("Check Recipe when active recipe is null");
            return ((TileEntityMachine)this.tile).getMachineState();
        }
        if (this.currentProgress >= this.maxProgress) {
            if (!this.canOutput()) {
                this.tickTimer += 20;
                return MachineState.OUTPUT_FULL;
            }
            MachineState state = this.recipeFinish();
            if (state != MachineState.ACTIVE) {
                return state;
            }
        }
        ((TileEntityMachine)this.tile).onRecipePreTick();
        if (!this.consumeResourceForRecipe(false)) {
            if (this.currentProgress == 0 && ((TileEntityMachine)this.tile).getMachineState() == ((TileEntityMachine)this.tile).getDefaultMachineState()) {
                return ((TileEntityMachine)this.tile).getDefaultMachineState();
            }
            this.recipeFailure();
            if (!this.generator) {
                this.tickTimer += 100;
                if (((TileEntityMachine)this.tile).getMachineState() == MachineState.ACTIVE && !((TileEntityMachine)this.tile).isMuffled()) {
                    this.tile.m_58904_().m_5594_(null, this.tile.m_58899_(), Ref.INTERRUPT, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return MachineState.POWER_LOSS;
            }
            this.tickTimer += 10;
            return MachineState.IDLE;
        }
        if (this.currentProgress != 0 || this.consumedResources || !this.shouldConsumeResources() || !this.consumeInputs()) {
            // empty if block
        }
        ++this.currentProgress;
        ((TileEntityMachine)this.tile).onRecipePostTick();
        return MachineState.ACTIVE;
    }

    protected boolean shouldConsumeResources() {
        return !this.generator;
    }

    protected void recipeFailure() {
        this.currentProgress = 0;
    }

    public boolean consumeResourceForRecipe(boolean simulate) {
        if (this.activeRecipe.getPower() > 0L) {
            if (((TileEntityMachine)this.tile).energyHandler.isPresent()) {
                if (!this.generator) {
                    long power = this.getPower();
                    GTTransaction transaction = ((TileEntityMachine)this.tile).energyHandler.map(eh -> eh.extract(GTTransaction.Mode.INTERNAL)).orElse(null);
                    if (transaction != null && transaction.isValid()) {
                        if (simulate) {
                            return transaction.eu >= power;
                        }
                        if (transaction.eu >= power) {
                            transaction.addData(power, Utils.sink());
                            transaction.commit();
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return this.consumeGeneratorResources(simulate);
            }
            if (((TileEntityMachine)this.tile).rfHandler.isPresent()) {
                if (!this.generator) {
                    long power = this.getPower();
                    long availableEnergy = ((TileEntityMachine)this.tile).rfHandler.map(eh -> eh.getStoredEnergy()).orElse(0L);
                    if (availableEnergy > 0L && availableEnergy >= power) {
                        if (!simulate) {
                            ((TileEntityMachine)this.tile).rfHandler.ifPresent(eh -> eh.setEnergy(availableEnergy - power));
                        }
                        return true;
                    }
                    return false;
                }
                return this.consumeRFGeneratorResources(simulate);
            }
            return false;
        }
        return true;
    }

    protected boolean validateRecipe(IRecipe r) {
        long voltage = this.generator ? ((TileEntityMachine)this.tile).getMaxOutputVoltage() : (long)((TileEntityMachine)this.tile).getMachineType().amps() * ((TileEntityMachine)this.tile).getMaxInputVoltage();
        boolean ok = voltage >= r.getPower() / (long)r.getAmps();
        List consumed = ((TileEntityMachine)this.tile).itemHandler.map(t -> t.consumeInputs(r, true)).orElse(Collections.emptyList());
        for (IRecipeValidator validator : r.getValidators()) {
            if (validator.validate(r, (TileEntityMachine<?>)this.tile)) continue;
            return false;
        }
        return ok && (consumed.size() > 0 || !r.hasInputItems() || this.consumedResources);
    }

    protected boolean hasLoadedInput() {
        return this.itemInputs.size() > 0 || this.fluidInputs.size() > 0;
    }

    public void checkRecipe() {
        if (this.activeRecipe != null) {
            return;
        }
        if (!((TileEntityTickable)((Object)this.tile)).hadFirstTick() && this.hasLoadedInput()) {
            if (!((TileEntityMachine)this.tile).getMachineState().allowRecipeCheck()) {
                return;
            }
            this.activeRecipe = ((TileEntityMachine)this.tile).getMachineType().getRecipeMap().find(this.itemInputs.toArray(new ItemStack[0]), this.fluidInputs.toArray(new FluidStack[0]), ((TileEntityMachine)this.tile).getMachineTier(), this::validateRecipe);
            if (this.activeRecipe == null) {
                return;
            }
            this.calculateDurations();
            this.lastRecipe = this.activeRecipe;
            return;
        }
        if (((TileEntityMachine)this.tile).getMachineState().allowRecipeCheck() && ((this.activeRecipe = this.cachedRecipe()) != null || (this.activeRecipe = this.findRecipe()) != null)) {
            if (!this.validateRecipe(this.activeRecipe)) {
                ((TileEntityMachine)this.tile).setMachineState(MachineState.INVALID_TIER);
                this.activeRecipe = null;
                return;
            }
            this.calculateDurations();
            if (!this.consumeResourceForRecipe(true) || !this.canRecipeContinue() || this.generator && (!this.activeRecipe.hasInputFluids() || this.activeRecipe.getInputFluids().size() != 1)) {
                this.activeRecipe = null;
                ((TileEntityMachine)this.tile).setMachineState(((TileEntityMachine)this.tile).getDefaultMachineState());
                this.tickTimer += 10;
                return;
            }
            this.activateRecipe(true);
            ((TileEntityMachine)this.tile).setMachineState(MachineState.ACTIVE);
        }
    }

    public boolean accepts(ItemStack stack) {
        IRecipeMap map = ((TileEntityMachine)this.tile).getMachineType().getRecipeMap();
        return map == null || map.acceptsItem(stack);
    }

    public boolean accepts(FluidStack stack) {
        IRecipeMap map = ((TileEntityMachine)this.tile).getMachineType().getRecipeMap();
        return map == null || map.acceptsFluid(stack);
    }

    @Nullable
    public IRecipe getActiveRecipe() {
        return this.activeRecipe;
    }

    public boolean consumeInputs() {
        boolean flag = true;
        if (!((TileEntityTickable)((Object)this.tile)).hadFirstTick()) {
            return true;
        }
        if (this.activeRecipe.hasInputItems()) {
            flag &= ((TileEntityMachine)this.tile).itemHandler.map(h -> {
                this.itemInputs = h.consumeInputs(this.activeRecipe, false);
                return !this.itemInputs.isEmpty();
            }).orElse(true).booleanValue();
        }
        if (this.activeRecipe.hasInputFluids()) {
            flag &= ((TileEntityMachine)this.tile).fluidHandler.map(h -> {
                this.fluidInputs = h.consumeAndReturnInputs(this.activeRecipe.getInputFluids(), false);
                return !this.fluidInputs.isEmpty();
            }).orElse(true).booleanValue();
        }
        if (flag) {
            this.consumedResources = true;
        }
        return flag;
    }

    public boolean canOutput() {
        if (((TileEntityMachine)this.tile).itemHandler.isPresent() && this.activeRecipe.hasOutputItems() && !((TileEntityMachine)this.tile).itemHandler.map(t -> t.canOutputsFit(this.activeRecipe.getFlatOutputItems())).orElse(false).booleanValue()) {
            return false;
        }
        return !((TileEntityMachine)this.tile).fluidHandler.isPresent() || !this.activeRecipe.hasOutputFluids() || ((TileEntityMachine)this.tile).fluidHandler.map(t -> t.canOutputsFit(this.activeRecipe.getOutputFluids())).orElse(false) != false;
    }

    protected boolean canRecipeContinue() {
        return !(!this.canOutput() || this.activeRecipe.hasInputItems() && ((TileEntityMachine)this.tile).itemHandler.map(i -> i.consumeInputs(this.activeRecipe, true).size() > 0).orElse(false) == false || this.activeRecipe.hasInputFluids() && ((TileEntityMachine)this.tile).fluidHandler.map(t -> t.consumeAndReturnInputs(this.activeRecipe.getInputFluids(), true).size() > 0).orElse(false) == false);
    }

    protected boolean consumeRFGeneratorResources(boolean simulate) {
        if (!this.activeRecipe.hasInputFluids()) {
            throw new RuntimeException("Missing fuel in active generator recipe!");
        }
        long toConsume = this.calculateGeneratorConsumption(this.activeRecipe);
        long actualConsume = toConsume;
        if (actualConsume == 0L || ((TileEntityMachine)this.tile).fluidHandler.map(h -> {
            FluidIngredient in = this.activeRecipe.getInputFluids().get(0);
            long amount = in.drainedAmount((int)actualConsume, (MachineFluidHandler<?>)h, true, true);
            if (amount == actualConsume) {
                if (!simulate) {
                    in.drain(amount, (MachineFluidHandler<?>)h, true, false);
                }
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            if (!simulate) {
                ((TileEntityMachine)this.tile).rfHandler.ifPresent(r -> r.setEnergy(r.getStoredEnergy() + this.activeRecipe.getPower()));
            }
            return true;
        }
        return false;
    }

    protected boolean consumeGeneratorResources(boolean simulate) {
        if (!this.activeRecipe.hasInputFluids()) {
            throw new RuntimeException("Missing fuel in active generator recipe!");
        }
        long toConsume = this.calculateGeneratorConsumption(((TileEntityMachine)this.tile).getMachineTier().getVoltage(), this.activeRecipe);
        long inserted = toConsume == 0L ? (long)((double)this.activeRecipe.getPower() / (double)this.activeRecipe.getInputFluids().get(0).getAmount() * ((TileEntityMachine)this.tile).getMachineType().getMachineEfficiency()) : (long)((double)toConsume * (double)this.activeRecipe.getPower() / (double)this.activeRecipe.getInputFluids().get(0).getAmount() * ((TileEntityMachine)this.tile).getMachineType().getMachineEfficiency());
        long t = inserted;
        GTTransaction transaction = new GTTransaction(t, Utils.sink());
        if (!((TileEntityMachine)this.tile).energyHandler.map(eh -> eh.insert(transaction)).orElse(false).booleanValue()) {
            return false;
        }
        long actual = t - transaction.eu;
        if (actual < inserted && toConsume == 0L) {
            return false;
        }
        while (actual < inserted && actual > 0L) {
            inserted = (long)((double)(--toConsume) * (double)this.activeRecipe.getPower() / (double)this.activeRecipe.getInputFluids().get(0).getAmount() * ((TileEntityMachine)this.tile).getMachineType().getMachineEfficiency());
            actual = Math.min(inserted, transaction.eu);
        }
        if (actual == 0L) {
            return false;
        }
        long actualConsume = toConsume;
        if (actualConsume == 0L || ((TileEntityMachine)this.tile).fluidHandler.map(h -> {
            FluidIngredient in = this.activeRecipe.getInputFluids().get(0);
            long amount = in.drainedAmount((int)actualConsume, (MachineFluidHandler<?>)h, true, true);
            if (amount == actualConsume) {
                if (!simulate) {
                    in.drain(amount, (MachineFluidHandler<?>)h, true, false);
                }
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            if (!simulate) {
                transaction.commit();
            }
            return true;
        }
        return false;
    }

    protected long calculateGeneratorConsumption(int volt, IRecipe r) {
        long power = r.getPower();
        long amount = r.getInputFluids().get(0).getAmount();
        if (this.currentProgress > 0 && amount == 1L) {
            return 0L;
        }
        double offset = (double)volt / ((double)power / (double)amount);
        if (r.getDuration() > 1) {
            offset /= (double)r.getDuration();
        }
        return Math.max(1L, (long)Math.ceil(offset));
    }

    protected long calculateGeneratorConsumption(IRecipe r) {
        long amount = r.getInputFluids().get(0).getAmount();
        if (this.currentProgress > 0) {
            return 0L;
        }
        return amount;
    }

    public void resetRecipe() {
        this.activeRecipe = null;
        this.consumedResources = false;
        this.currentProgress = 0;
        this.overclock = 0;
        this.maxProgress = 0;
        this.itemInputs = Collections.emptyList();
        this.fluidInputs = Collections.emptyList();
    }

    public void onMultiBlockStateChange(boolean isValid, boolean hardcore) {
        if (isValid) {
            if (((TileEntityTickable)((Object)this.tile)).hadFirstTick()) {
                if (this.hasRecipe()) {
                    ((TileEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
                } else {
                    this.checkRecipe();
                }
            }
        } else {
            if (this.activeRecipe != null) {
                ((TileEntityMachine)this.tile).onMachineStop();
            }
            if (hardcore) {
                this.resetRecipe();
            }
            ((TileEntityMachine)this.tile).resetMachine();
        }
    }

    public void onRemove() {
        this.resetRecipe();
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (this.tickingRecipe) {
            return;
        }
        if (event instanceof ContentEvent) {
            if (((TileEntityMachine)this.tile).getMachineState() == MachineState.ACTIVE) {
                return;
            }
            if (((TileEntityMachine)this.tile).getMachineState() == MachineState.POWER_LOSS) {
                return;
            }
            if (this.activeRecipe != null && !this.consumeResourceForRecipe(true)) {
                return;
            }
            if (event == ContentEvent.ENERGY_SLOT_CHANGED && ((TileEntityMachine)this.tile).itemHandler.map(t -> ((TrackedItemHandler)t.inventories.get(SlotType.ENERGY)).getStackInSlot((Integer)data[0]).m_41619_()).orElse(true).booleanValue()) {
                return;
            }
            if ((event == ContentEvent.ITEM_OUTPUT_CHANGED || event == ContentEvent.FLUID_OUTPUT_CHANGED) && ((TileEntityMachine)this.tile).getMachineState() == MachineState.OUTPUT_FULL && this.tickTimer == 0 && this.canOutput()) {
                this.tickingRecipe = true;
                ((TileEntityMachine)this.tile).setMachineState(this.recipeFinish());
                this.tickingRecipe = false;
                return;
            }
            if (((TileEntityMachine)this.tile).getMachineState().allowRecipeCheck()) {
                if (this.activeRecipe != null) {
                    ((TileEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
                } else if (((TileEntityMachine)this.tile).getMachineState() != MachineState.POWER_LOSS && this.tickTimer == 0) {
                    this.checkRecipe();
                } else if (event == ContentEvent.ITEM_INPUT_CHANGED || event == ContentEvent.FLUID_INPUT_CHANGED) {
                    this.checkRecipe();
                }
            }
        } else if (event instanceof MachineEvent) {
            switch ((MachineEvent)event) {
                case ENERGY_INPUTTED: 
                case HEAT_INPUTTED: {
                    if (event == MachineEvent.HEAT_INPUTTED && !((TileEntityMachine)this.tile).has(MachineFlag.HEAT)) break;
                    if (((TileEntityMachine)this.tile).getMachineState() == ((TileEntityMachine)this.tile).getDefaultMachineState() && this.activeRecipe != null) {
                        ((TileEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
                    }
                    if (!((TileEntityMachine)this.tile).getMachineState().allowRecipeCheck() || ((TileEntityMachine)this.tile).getMachineState() == MachineState.POWER_LOSS || this.tickTimer != 0) break;
                    this.checkRecipe();
                    break;
                }
                case ENERGY_DRAINED: 
                case HEAT_DRAINED: {
                    if (event == MachineEvent.HEAT_DRAINED && !((TileEntityMachine)this.tile).has(MachineFlag.HEAT) || !this.generator || ((TileEntityMachine)this.tile).getMachineState() != ((TileEntityMachine)this.tile).getDefaultMachineState()) break;
                    if (this.activeRecipe != null) {
                        ((TileEntityMachine)this.tile).setMachineState(MachineState.NO_POWER);
                        break;
                    }
                    this.checkRecipe();
                }
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag item = new ListTag();
        if (this.itemInputs.size() > 0) {
            this.itemInputs.forEach(t -> item.add((Object)t.m_41739_(new CompoundTag())));
        }
        ListTag fluid = new ListTag();
        if (this.fluidInputs.size() > 0) {
            this.fluidInputs.forEach(t -> fluid.add((Object)t.writeToNBT(new CompoundTag())));
        }
        nbt.m_128365_("I", (Tag)item);
        nbt.m_128405_("T", this.tickTimer);
        nbt.m_128365_("F", (Tag)fluid);
        nbt.m_128405_("P", this.currentProgress);
        nbt.m_128379_("C", this.consumedResources);
        if (this.activeRecipe != null) {
            nbt.m_128359_("AR", this.activeRecipe.m_6423_().toString());
        }
        if (this.lastRecipe != null) {
            nbt.m_128359_("LR", this.lastRecipe.m_6423_().toString());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.itemInputs = new ObjectArrayList();
        this.fluidInputs = new ObjectArrayList();
        nbt.m_128437_("I", 10).forEach(t -> this.itemInputs.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)t))));
        nbt.m_128437_("F", 10).forEach(t -> this.fluidInputs.add(FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)t))));
        this.currentProgress = nbt.m_128451_("P");
        this.tickTimer = nbt.m_128451_("T");
        this.consumedResources = nbt.m_128471_("C");
        this.activeRecipe = nbt.m_128441_("AR") ? ((TileEntityMachine)this.tile).getMachineType().getRecipeMap().findByID(new ResourceLocation(nbt.m_128461_("AR"))) : null;
        IRecipe iRecipe = this.lastRecipe = nbt.m_128441_("LR") ? ((TileEntityMachine)this.tile).getMachineType().getRecipeMap().findByID(new ResourceLocation(nbt.m_128461_("LR"))) : null;
        if (this.activeRecipe != null) {
            this.calculateDurations();
        }
    }

    @Override
    public LazyOptional<MachineRecipeHandler<?>> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<MachineRecipeHandler<?>> forNullSide() {
        return LazyOptional.of(() -> this);
    }
}

