/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import com.google.common.collect.ImmutableList;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.PlatformItemEnergyManager;
import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.capability.IMachineHandler;
import muramasa.antimatter.capability.machine.MachineItemHandler;
import muramasa.antimatter.capability.rf.RFHandler;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.event.MachineEvent;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import tesseract.api.rf.IRFNode;

public class MachineRFHandler<T extends TileEntityMachine<T>>
extends RFHandler
implements IMachineHandler,
Dispatch.Sided<IRFNode> {
    protected final T tile;
    protected List<Pair<ItemStack, PlatformItemEnergyManager>> cachedItems = new ObjectArrayList();
    protected int offsetInsert = 0;
    protected int offsetExtract = 0;

    public MachineRFHandler(T tile, long energy, long capacity, int maxIn, int maxOut) {
        super(energy, capacity, maxIn, maxOut);
        this.tile = tile;
    }

    public MachineRFHandler(T tile, long capacity, boolean isGenerator) {
        this(tile, 0L, capacity, isGenerator ? 0 : ((TileEntityMachine)tile).getMachineTier().getVoltage(), isGenerator ? ((TileEntityMachine)tile).getMachineTier().getVoltage() : 0);
    }

    public void onUpdate() {
        for (Direction dir : Ref.DIRS) {
            BlockEntity tile;
            if (!this.canOutput(dir) || (tile = this.tile.m_58904_().m_7702_(this.tile.m_58899_().m_142300_(dir))) == null) continue;
            Optional handle = EnergyHooks.safeGetBlockEnergyManager((BlockEntity)tile, (Direction)dir.m_122424_());
            handle.ifPresent(eh -> Utils.transferEnergy((EnergyContainer)this, eh));
        }
    }

    @Override
    public void init() {
        this.cachedItems = (List)((TileEntityMachine)this.tile).itemHandler.map(MachineItemHandler::getRFChargeableItems).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    @Override
    public long getMaxCapacity() {
        if (this.canChargeItem()) {
            return super.getMaxCapacity() + (this.cachedItems != null ? this.cachedItems.stream().map(Pair::right).mapToLong(PlatformItemEnergyManager::getCapacity).sum() : 0L);
        }
        return super.getMaxCapacity();
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        long inserted = super.insertEnergy(maxAmount, simulate);
        int i = this.offsetInsert;
        for (int j = 0; j < this.cachedItems.size(); ++j) {
            ItemStack stack;
            ItemStackHolder holder;
            long insert;
            PlatformItemEnergyManager handler = (PlatformItemEnergyManager)this.cachedItems.get(i).right();
            if (handler.supportsInsertion() && (insert = handler.insert(holder = new ItemStackHolder(stack = (ItemStack)this.cachedItems.get(i).left()), maxAmount, simulate)) > 0L) {
                if (holder.isDirty()) {
                    stack.m_41751_(holder.getStack().m_41783_());
                    stack.m_41764_(holder.getStack().m_41613_());
                }
                this.offsetInsert = (this.offsetInsert + 1) % this.cachedItems.size();
                inserted += insert;
            }
            i = i == this.cachedItems.size() - 1 ? 0 : i + 1;
        }
        if (inserted > 0L) {
            ((TileEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_INPUTTED, new Object[0]);
        }
        return inserted;
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        long extracted = super.extractEnergy(maxAmount, simulate);
        int i = this.offsetInsert;
        for (int j = 0; j < this.cachedItems.size(); ++j) {
            ItemStack stack;
            ItemStackHolder holder;
            long extract;
            PlatformItemEnergyManager handler = (PlatformItemEnergyManager)this.cachedItems.get(i).right();
            if (handler.supportsExtraction() && (extract = handler.extract(holder = new ItemStackHolder(stack = (ItemStack)this.cachedItems.get(i).left()), maxAmount, simulate)) > 0L) {
                if (holder.isDirty()) {
                    stack.m_41751_(holder.getStack().m_41783_());
                    stack.m_41764_(holder.getStack().m_41613_());
                }
                this.offsetInsert = (this.offsetInsert + 1) % this.cachedItems.size();
                extracted += extract;
            }
            i = i == this.cachedItems.size() - 1 ? 0 : i + 1;
        }
        if (extracted > 0L) {
            ((TileEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_INPUTTED, new Object[0]);
        }
        return extracted;
    }

    @Override
    public long getStoredEnergy() {
        if (this.canChargeItem()) {
            return super.getStoredEnergy() + (this.cachedItems != null ? this.cachedItems.stream().map(Pair::right).mapToLong(PlatformItemEnergyManager::getStoredEnergy).sum() : 0L);
        }
        return super.getStoredEnergy();
    }

    @Override
    public boolean canInput(Direction direction) {
        return super.canInput(direction) && (((TileEntityMachine)this.tile).getFacing() != direction || ((TileEntityMachine)this.tile).getMachineType().allowsFrontIO());
    }

    public boolean canChargeItem() {
        return true;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (event == ContentEvent.ENERGY_SLOT_CHANGED) {
            ((TileEntityMachine)this.tile).itemHandler.ifPresent(h -> {
                this.cachedItems = h.getRFChargeableItems();
                this.offsetInsert = 0;
                this.offsetExtract = 0;
            });
        }
    }

    @Override
    public LazyOptional<? extends IRFNode> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends IRFNode> forNullSide() {
        return LazyOptional.of(() -> this);
    }

    public void onRemove() {
    }
}

