/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.capability.FluidHandler;
import muramasa.antimatter.capability.fluid.FluidHandlerNullSideWrapper;
import muramasa.antimatter.capability.fluid.FluidHandlerSidedWrapper;
import muramasa.antimatter.capability.fluid.FluidTanks;
import muramasa.antimatter.capability.machine.MachineItemHandler;
import muramasa.antimatter.gui.SlotType;
import muramasa.antimatter.machine.MachineFlag;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.recipe.IRecipe;
import muramasa.antimatter.recipe.ingredient.FluidIngredient;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import tesseract.FluidPlatformUtils;
import tesseract.TesseractGraphWrappers;

public class MachineFluidHandler<T extends TileEntityMachine<T>>
extends FluidHandler<T>
implements Dispatch.Sided<IFluidHandler> {
    private boolean fillingCell = false;
    protected boolean filledLastTick = false;
    private int lastCellSlot = 0;

    public MachineFluidHandler(T tile, int capacity, int pressure) {
        this(tile, capacity, pressure, ((TileEntityMachine)tile).has(MachineFlag.GUI) ? ((TileEntityMachine)tile).getMachineType().getSlots(SlotType.FL_IN, ((TileEntityMachine)tile).getMachineTier()).size() : 0, ((TileEntityMachine)tile).has(MachineFlag.GUI) ? ((TileEntityMachine)tile).getMachineType().getSlots(SlotType.FL_OUT, ((TileEntityMachine)tile).getMachineTier()).size() : 0);
    }

    public MachineFluidHandler(T tile, int capacity, int pressure, int inputCount, int outputCount) {
        super(tile, capacity, pressure, inputCount, outputCount);
    }

    public MachineFluidHandler(T tile) {
        this(tile, 8000 * (1 + ((TileEntityMachine)tile).getMachineTier().getIntegerId()), 1000 * (250 + ((TileEntityMachine)tile).getMachineTier().getIntegerId()));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.filledLastTick) {
            this.tryFillCell(this.lastCellSlot, -1L);
        }
    }

    public void fillCell(int cellSlot, long maxFill) {
        if (this.fillingCell) {
            return;
        }
        this.fillingCell = true;
        this.filledLastTick = this.getInputTanks() != null ? ((TileEntityMachine)this.tile).itemHandler.map(ih -> {
            if (ih.getCellInputHandler() == null) {
                return false;
            }
            ItemStack cell = ih.getCellInputHandler().getStackInSlot(cellSlot);
            if (cell.m_41619_()) {
                return false;
            }
            FluidActionResult result = FluidPlatformUtils.tryFillContainer((ItemStack)cell, (IFluidHandler)this.getCellAccessibleTanks(), (long)maxFill, null, (boolean)false);
            if (result.isSuccess()) {
                ItemStack insert = result.getResult();
                if (!MachineItemHandler.insertIntoOutput((IItemHandler)ih.getCellOutputHandler(), cellSlot, insert, true).m_41619_()) {
                    return false;
                }
                FluidPlatformUtils.tryFillContainer((ItemStack)cell, (IFluidHandler)this.getCellAccessibleTanks(), (long)maxFill, null, (boolean)true);
                MachineItemHandler.insertIntoOutput((IItemHandler)ih.getCellOutputHandler(), cellSlot, insert, false);
                MachineItemHandler.extractFromInput((IItemHandler)ih.getCellInputHandler(), cellSlot, 1, false);
                this.lastCellSlot = cellSlot;
                return true;
            }
            result = FluidPlatformUtils.tryEmptyContainer((ItemStack)cell, (IFluidHandler)this.getCellAccessibleTanks(), (long)maxFill, null, (boolean)false);
            if (result.isSuccess()) {
                ItemStack insert = result.getResult();
                if (!MachineItemHandler.insertIntoOutput((IItemHandler)ih.getCellOutputHandler(), cellSlot, insert, true).m_41619_()) {
                    return false;
                }
                FluidPlatformUtils.tryEmptyContainer((ItemStack)cell, (IFluidHandler)this.getCellAccessibleTanks(), (long)maxFill, null, (boolean)true);
                MachineItemHandler.insertIntoOutput((IItemHandler)ih.getCellOutputHandler(), cellSlot, insert, false);
                MachineItemHandler.extractFromInput((IItemHandler)ih.getCellInputHandler(), cellSlot, 1, false);
                this.lastCellSlot = cellSlot;
                return true;
            }
            return false;
        }).orElse(false) : false;
        this.fillingCell = false;
    }

    protected FluidTanks getCellAccessibleTanks() {
        return this.getAllTanks();
    }

    @Override
    protected boolean checkValidFluid(FluidStack fluid) {
        IRecipe recipe;
        if (((TileEntityMachine)this.tile).has(MachineFlag.GENERATOR) && (recipe = ((TileEntityMachine)this.tile).getMachineType().getRecipeMap().find(new ItemStack[0], new FluidStack[]{fluid}, Tier.ULV, r -> true)) != null) {
            return true;
        }
        return true;
    }

    protected void tryFillCell(int slot, long maxFill) {
        if (((TileEntityMachine)this.tile).itemHandler.map(MachineItemHandler::getCellCount).orElse(0) > 0) {
            this.fillCell(slot, maxFill);
        }
    }

    @Override
    public long fillDroplets(FluidStack stack, IFluidHandler.FluidAction action) {
        if (!((TileEntityMachine)this.tile).recipeHandler.map(t -> t.accepts(stack)).orElse(true).booleanValue()) {
            return 0L;
        }
        return super.fillDroplets(stack, action);
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        super.onMachineEvent(event, data);
        if (event instanceof ContentEvent) {
            switch ((ContentEvent)event) {
                case ITEM_CELL_CHANGED: {
                    if (!(data[0] instanceof Integer)) break;
                    this.tryFillCell((Integer)data[0], -1L);
                    break;
                }
                case FLUID_INPUT_CHANGED: 
                case FLUID_OUTPUT_CHANGED: {
                    if (data[0] instanceof Integer) {
                        this.tryFillCell((Integer)data[0], -1L);
                    }
                    if (!((TileEntityMachine)this.tile).getMachineType().renderContainerLiquids()) break;
                    ((TileEntityMachine)this.tile).sidedSync(true);
                }
            }
        }
    }

    public boolean canOutputsFit(FluidStack[] outputs) {
        return this.getSpaceForOutputs(outputs) >= outputs.length;
    }

    public int getSpaceForOutputs(FluidStack[] outputs) {
        int matchCount = 0;
        if (this.getOutputTanks() != null) {
            for (FluidStack output : outputs) {
                if (this.fillOutput(output, IFluidHandler.FluidAction.SIMULATE) != output.getRealAmount()) continue;
                ++matchCount;
            }
        }
        return matchCount;
    }

    public void addOutputs(FluidStack ... fluids) {
        if (this.getOutputTanks() == null) {
            return;
        }
        if (fluids != null) {
            for (FluidStack input : fluids) {
                this.fillOutput(input, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public int getTankForTag(TagKey<Fluid> tag, int min) {
        FluidStack[] inputs = this.getInputs();
        for (int i = min; i < inputs.length; ++i) {
            FluidStack input = inputs[i];
            if (!input.getFluid().m_205069_().m_203656_(tag)) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public FluidStack consumeTaggedInput(TagKey<Fluid> input, int amount, boolean simulate) {
        FluidTanks inputs = this.getInputTanks();
        if (inputs == null) {
            return FluidStack.EMPTY;
        }
        int id = this.getTankForTag(input, 0);
        if (id == -1) {
            return FluidStack.EMPTY;
        }
        return inputs.drain(new FluidStack(inputs.getFluidInTank(id).getFluid(), amount), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @Nonnull
    public List<FluidStack> consumeAndReturnInputs(List<FluidIngredient> inputs, boolean simulate) {
        if (this.getInputTanks() == null) {
            return Collections.emptyList();
        }
        ObjectArrayList consumed = new ObjectArrayList();
        boolean ret = true;
        if (inputs != null) {
            for (FluidIngredient input : inputs) {
                List<FluidStack> inner = input.drain(this, true, simulate);
                if (inner.stream().mapToLong(FluidStack::getRealAmount).sum() != input.getAmount()) {
                    ret = false;
                    continue;
                }
                consumed.addAll(inner);
            }
        }
        return consumed;
    }

    public FluidStack[] exportAndReturnOutputs(FluidStack ... outputs) {
        if (this.getOutputTanks() == null) {
            return new FluidStack[0];
        }
        ObjectArrayList notExported = new ObjectArrayList();
        for (int i = 0; i < outputs.length; ++i) {
            long result = this.fillDroplets(outputs[i], IFluidHandler.FluidAction.EXECUTE);
            if (result == 0L) {
                notExported.add(outputs[i]);
                continue;
            }
            outputs[i] = Utils.ca(result, outputs[i]);
        }
        return notExported.toArray(new FluidStack[0]);
    }

    @Override
    public boolean canOutput(Direction direction) {
        if (((TileEntityMachine)this.tile).getFacing().m_122411_() == direction.m_122411_() && !((TileEntityMachine)this.tile).getMachineType().allowsFrontIO()) {
            return false;
        }
        return super.canOutput();
    }

    @Override
    public boolean canInput(FluidStack fluid, Direction direction) {
        return true;
    }

    @Override
    public boolean canInput(Direction direction) {
        if (((TileEntityMachine)this.tile).getFacing().m_122411_() == direction.m_122411_() && !((TileEntityMachine)this.tile).getMachineType().allowsFrontIO()) {
            return false;
        }
        return super.canInput();
    }

    @Override
    public int getPriority(Direction direction) {
        return ((TileEntityMachine)this.tile).coverHandler.map(c -> c.get(direction).getPriority(IFluidHandler.class)).orElse(0);
    }

    @Override
    public LazyOptional<? extends IFluidHandler> forNullSide() {
        return LazyOptional.of(() -> new FluidHandlerNullSideWrapper((IFluidHandler)this));
    }

    @Override
    public LazyOptional<IFluidHandler> forSide(Direction side) {
        return LazyOptional.of(() -> new FluidHandlerSidedWrapper(this, ((TileEntityMachine)this.tile).coverHandler.map(c -> c).orElse(null), side));
    }

    public IFluidHandler getGuiHandler() {
        return new IFluidHandler(){

            public int getTanks() {
                return MachineFluidHandler.this.getTanks();
            }

            @Nonnull
            public FluidStack getFluidInTank(int tank) {
                return MachineFluidHandler.this.getFluidInTank(tank);
            }

            public long getTankCapacityInDroplets(int tank) {
                return MachineFluidHandler.this.getTankCapacityInDroplets(tank);
            }

            public long fillDroplets(FluidStack stack, IFluidHandler.FluidAction action) {
                return MachineFluidHandler.this.fillDroplets(stack, action);
            }

            public int getTankCapacity(int tank) {
                return MachineFluidHandler.this.getTankCapacity(tank);
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return MachineFluidHandler.this.isFluidValid(tank, stack);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return MachineFluidHandler.this.fill(resource, action);
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                FluidStack ret = MachineFluidHandler.this.drain(resource, action);
                return ret.isEmpty() ? MachineFluidHandler.this.drainInput(resource, action) : ret;
            }

            public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
                return this.drain((long)amount * TesseractGraphWrappers.dropletMultiplier, action);
            }

            @Nonnull
            public FluidStack drain(long maxDrain, IFluidHandler.FluidAction action) {
                FluidStack ret = MachineFluidHandler.this.drain(maxDrain, action);
                return ret.isEmpty() ? MachineFluidHandler.this.drainInput(maxDrain, action) : ret;
            }
        };
    }
}

