/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.capability.EnergyHandler;
import muramasa.antimatter.capability.IMachineHandler;
import muramasa.antimatter.capability.machine.MachineItemHandler;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.machine.event.MachineEvent;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import tesseract.TesseractCapUtils;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IEnergyHandlerItem;
import tesseract.api.gt.IGTNode;

public class MachineEnergyHandler<T extends TileEntityMachine<T>>
extends EnergyHandler
implements IMachineHandler,
Dispatch.Sided<IEnergyHandler> {
    protected final T tile;
    protected long capacty;
    protected List<Pair<ItemStack, IEnergyHandlerItem>> cachedItems = new ObjectArrayList();
    protected int offsetInsert = 0;
    protected int offsetExtract = 0;

    public MachineEnergyHandler(T tile, long energy, long capacity, int voltageIn, int voltageOut, int amperageIn, int amperageOut) {
        super(energy, capacity, voltageIn, voltageOut, amperageIn, amperageOut);
        this.capacty = capacity;
        this.tile = tile;
    }

    public MachineEnergyHandler(T tile, boolean isGenerator) {
        this(tile, 1, isGenerator);
    }

    public MachineEnergyHandler(T tile, int amps, boolean isGenerator) {
        this(tile, 0L, (long)((TileEntityMachine)tile).getMachineTier().getVoltage() * (isGenerator ? 40L : 66L), isGenerator ? 0 : ((TileEntityMachine)tile).getMachineTier().getVoltage(), isGenerator ? ((TileEntityMachine)tile).getMachineTier().getVoltage() : 0, isGenerator ? 0 : amps, isGenerator ? amps : 0);
    }

    @Override
    public void init() {
        this.cachedItems = (List)((TileEntityMachine)this.tile).itemHandler.map(MachineItemHandler::getChargeableItems).map(ImmutableList::copyOf).orElse(ImmutableList.of());
    }

    public void setCapacty(long capacty) {
        this.capacty = capacty;
    }

    public List<Pair<ItemStack, IEnergyHandlerItem>> getCachedEnergyItems() {
        return this.cachedItems;
    }

    public void onRemove() {
    }

    @Override
    protected boolean checkVoltage(GTTransaction.TransferData data) {
        if (data.getVoltage() > this.getInputVoltage()) {
            if (AntimatterConfig.GAMEPLAY.MACHINES_EXPLODE) {
                Utils.createExplosion(this.tile.m_58904_(), this.tile.m_58899_(), 4.0f, Explosion.BlockInteraction.DESTROY);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public long getCapacity() {
        if (this.canChargeItem()) {
            return this.capacity + (this.cachedItems != null ? this.cachedItems.stream().map(Pair::right).mapToLong(IGTNode::getCapacity).sum() : 0L);
        }
        return this.capacity;
    }

    @Override
    public boolean addEnergy(GTTransaction.TransferData data) {
        boolean ok = super.addEnergy(data);
        int i = this.offsetInsert;
        for (int j = 0; j < this.cachedItems.size(); ++j) {
            IEnergyHandlerItem handler = (IEnergyHandlerItem)this.cachedItems.get(i).right();
            if (handler.addEnergy(data)) {
                ((ItemStack)this.cachedItems.get(i).left()).m_41751_(handler.getContainer().getTag());
                this.offsetInsert = (this.offsetInsert + 1) % this.cachedItems.size();
                ok = true;
            }
            i = i == this.cachedItems.size() - 1 ? 0 : i + 1;
        }
        if (ok) {
            ((TileEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_INPUTTED, new Object[0]);
        }
        return ok;
    }

    @Override
    public boolean extractEnergy(GTTransaction.TransferData data) {
        boolean ok = super.extractEnergy(data);
        int i = this.offsetExtract;
        for (int j = 0; j < this.cachedItems.size(); ++j) {
            IEnergyHandlerItem handler = (IEnergyHandlerItem)this.cachedItems.get(i).right();
            if (handler.extractEnergy(data)) {
                ((ItemStack)this.cachedItems.get(i).left()).m_41751_(handler.getContainer().getTag());
                this.offsetExtract = (this.offsetExtract + 1) % this.cachedItems.size();
                ok = true;
            }
            i = i == this.cachedItems.size() - 1 ? 0 : i + 1;
        }
        if (ok) {
            ((TileEntityMachine)this.tile).onMachineEvent(MachineEvent.ENERGY_DRAINED, new Object[0]);
        }
        return ok;
    }

    @Override
    public long getEnergy() {
        if (this.canChargeItem()) {
            return super.getEnergy() + (this.cachedItems != null ? this.cachedItems.stream().map(Pair::right).mapToLong(IGTNode::getEnergy).sum() : 0L);
        }
        return super.getEnergy();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.cachedItems.forEach(t -> ((IEnergyHandlerItem)t.right()).getState().onTick());
        for (Direction dir : Ref.DIRS) {
            BlockEntity tile;
            if (!this.canOutput(dir) || (tile = this.tile.m_58904_().m_7702_(this.tile.m_58899_().m_142300_(dir))) == null) continue;
            Optional handle = TesseractCapUtils.getEnergyHandler((BlockEntity)tile, (Direction)dir.m_122424_());
            handle.ifPresent(eh -> Utils.transferEnergy(this, eh));
        }
    }

    public long availableAmpsOutput() {
        return super.availableAmpsOutput() + this.cachedItems.stream().map(Pair::right).mapToLong(IGTNode::availableAmpsOutput).sum();
    }

    public long availableAmpsInput() {
        return super.availableAmpsInput() + this.cachedItems.stream().map(Pair::right).mapToLong(IGTNode::availableAmpsInput).sum();
    }

    @Override
    public boolean canInput(Direction direction) {
        return super.canInput(direction) && (((TileEntityMachine)this.tile).getFacing() != direction || ((TileEntityMachine)this.tile).getMachineType().allowsFrontIO());
    }

    public boolean canChargeItem() {
        return true;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        if (event == ContentEvent.ENERGY_SLOT_CHANGED) {
            ((TileEntityMachine)this.tile).itemHandler.ifPresent(h -> {
                this.cachedItems = h.getChargeableItems();
                this.offsetInsert = 0;
                this.offsetExtract = 0;
            });
        }
    }

    @Override
    public LazyOptional<IEnergyHandler> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends IEnergyHandler> forNullSide() {
        return LazyOptional.of(() -> this);
    }
}

