/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.Ref;
import muramasa.antimatter.capability.CoverHandler;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.capability.ICoverHandler;
import muramasa.antimatter.capability.IMachineHandler;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tool.AntimatterToolType;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class MachineCoverHandler<T extends TileEntityMachine<T>>
extends CoverHandler<T>
implements IMachineHandler,
Dispatch.Sided<ICoverHandler<?>> {
    public MachineCoverHandler(T tile) {
        super(tile, ((TileEntityMachine)tile).getValidCovers());
        Arrays.stream(Ref.DIRS).forEach(d -> {
            Direction facing = this.getTileFacing();
            Direction newDir = Utils.coverRotateFacing(d, facing);
            this.covers.put(d, (Object)tile.getMachineType().defaultCover(newDir).get().get(this, null, (Direction)d, tile.getMachineType().defaultCover(newDir)));
            this.buildLookup(ICover.emptyFactory, tile.getMachineType().defaultCover(newDir), (Direction)d);
        });
    }

    public Direction getOutputFacing() {
        return this.lookupSingle(((TileEntityMachine)this.getTile()).getMachineType().getOutputCover());
    }

    public ICover getOutputCover() {
        return this.get(this.lookupSingle(((TileEntityMachine)this.getTile()).getMachineType().getOutputCover()));
    }

    public boolean setOutputFacing(Player entity, Direction side) {
        Direction dir = this.getOutputFacing();
        if (dir == null) {
            return false;
        }
        if (side == dir) {
            return false;
        }
        if (this.getTileFacing() == side && !((TileEntityMachine)this.getTile()).getMachineType().allowsFrontCovers()) {
            return false;
        }
        boolean ok = this.moveCover(entity, dir, side);
        if (ok) {
            ((TileEntityMachine)this.getTile()).invalidateCaps();
        }
        return ok;
    }

    @Override
    public boolean set(Direction side, ICover old, ICover stack, boolean sync) {
        if (this.getTileFacing() == side && !((TileEntityMachine)this.getTile()).getMachineType().allowsFrontCovers()) {
            return false;
        }
        boolean ok = super.set(side, old, stack, sync);
        if (ok && ((TileEntityMachine)this.getTile()).m_58904_() != null) {
            if (!((TileEntityMachine)this.getTile()).m_58904_().f_46443_) {
                ((TileEntityMachine)this.getTile()).invalidateCaps(side);
            } else if (this.coverTexturer != null) {
                this.getTexturer(side).invalidate();
            }
        }
        return ok;
    }

    @Override
    protected boolean canRemoveCover(ICover cover) {
        return ((TileEntityMachine)this.getTile()).getMachineType().getOutputCover() != cover.getFactory();
    }

    @Override
    public boolean onInteract(@Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull Direction side, @Nullable AntimatterToolType type) {
        return super.onInteract(player, hand, side, type);
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
        this.covers.forEach((s, c) -> c.onMachineEvent((TileEntityMachine)this.getTile(), event, new int[0]));
    }

    @Override
    public boolean isValid(@Nonnull Direction side, @Nonnull ICover replacement) {
        if (!this.validCovers.contains(replacement.getLoc())) {
            return false;
        }
        if (side == this.getOutputFacing()) {
            return false;
        }
        return this.get(side).isEmpty() && !replacement.isEmpty() || super.isValid(side, replacement);
    }

    public Direction getTileFacing() {
        return ((TileEntityMachine)this.getTile()).getFacing();
    }

    @Override
    public LazyOptional<ICoverHandler<?>> forSide(Direction side) {
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends ICoverHandler<?>> forNullSide() {
        return LazyOptional.of(() -> this);
    }
}

