/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.machine;

import muramasa.antimatter.Data;
import muramasa.antimatter.capability.Dispatch;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import tesseract.TesseractCapUtils;
import tesseract.api.heat.HeatTransaction;
import tesseract.api.heat.IHeatHandler;

public class DefaultHeatHandler
implements IHeatHandler,
Dispatch.Sided<IHeatHandler> {
    public final int heatCap;
    public final int temperaturesize;
    protected int currentHeat;
    public final TileEntityBase<?> tile;

    public DefaultHeatHandler(TileEntityBase<?> tile, int heatCap, int temperatureSize) {
        this.heatCap = heatCap;
        this.tile = tile;
        this.temperaturesize = temperatureSize;
    }

    public HeatTransaction extract() {
        if (this.currentHeat < this.temperaturesize) {
            return new HeatTransaction(0, 0, Utils.sink());
        }
        return new HeatTransaction(this.temperaturesize, this.getTemperature(), this::sub);
    }

    public void insert(HeatTransaction transaction) {
        int availableToInsert = transaction.available();
        if ((availableToInsert = Math.min(this.heatCap - this.currentHeat, availableToInsert)) > 0) {
            transaction.addData(availableToInsert, this.getTemperature(), this::add);
        }
    }

    protected void sub(Integer temp) {
        this.currentHeat -= temp.intValue();
    }

    protected void add(Integer temp) {
        this.currentHeat += temp.intValue();
    }

    public int getTemperature() {
        return this.currentHeat / this.temperaturesize;
    }

    public void update(boolean active) {
        HeatTransaction tx;
        boolean doTransfer;
        boolean bl = doTransfer = this.tile.m_58904_().m_46467_() % 20L == 0L;
        if (doTransfer && (tx = this.extract()).isValid()) {
            Utils.entitiesAround(this.tile.m_58904_(), this.tile.m_58899_(), (dir, ent) -> TesseractCapUtils.getHeatHandler((BlockEntity)ent, (Direction)dir.m_122424_()).ifPresent(t -> t.insert(tx)));
            tx.commit();
        }
        if (!active) {
            this.currentHeat -= this.temperaturesize / 40;
            this.currentHeat = Math.max(0, this.currentHeat);
        }
    }

    public int getHeat() {
        return this.currentHeat;
    }

    public int getHeatCap() {
        return this.heatCap;
    }

    @Override
    public LazyOptional<? extends IHeatHandler> forSide(Direction side) {
        TileEntityBase<?> tileEntityBase = this.tile;
        if (tileEntityBase instanceof TileEntityMachine) {
            TileEntityMachine m = (TileEntityMachine)tileEntityBase;
            if (side == null) {
                return LazyOptional.of(() -> this);
            }
            if (m.coverHandler.map(t -> t.get(side).getFactory() == Data.COVERHEAT).orElse(false).booleanValue()) {
                return LazyOptional.of(() -> this);
            }
            return LazyOptional.empty();
        }
        return LazyOptional.of(() -> this);
    }

    @Override
    public LazyOptional<? extends IHeatHandler> forNullSide() {
        return this.forSide(null);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("mh", this.currentHeat);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.currentHeat = nbt.m_128451_("mh");
    }
}

