/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.item;

import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import muramasa.antimatter.capability.IGuiHandler;
import muramasa.antimatter.capability.item.ITrackedHandler;
import muramasa.antimatter.capability.item.ItemStackHandler;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.tile.TileEntityMachine;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class TrackedItemHandler<T extends TileEntityMachine<T>>
extends ItemStackHandler
implements ITrackedHandler {
    private final T tile;
    private final ContentEvent contentEvent;
    private final boolean output;
    private final boolean input;
    private final BiPredicate<IGuiHandler, ItemStack> validator;
    private final int limit;
    private final int size;

    public TrackedItemHandler(T tile, int size, boolean output, boolean input, BiPredicate<IGuiHandler, ItemStack> validator, ContentEvent contentEvent) {
        this(tile, size, output, input, validator, contentEvent, 64);
    }

    public TrackedItemHandler(T tile, int size, boolean output, boolean input, BiPredicate<IGuiHandler, ItemStack> validator, ContentEvent contentEvent, int limit) {
        super(size);
        this.tile = tile;
        this.output = output;
        this.input = input;
        this.contentEvent = contentEvent;
        this.validator = validator;
        this.limit = limit;
        this.size = size;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.limit;
    }

    @Override
    public void onContentsChanged(int slot) {
        this.tile.m_6596_();
        ((TileEntityMachine)this.tile).onMachineEvent(this.contentEvent, slot);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (!this.input) {
            return stack;
        }
        boolean validate = this.validator.test((IGuiHandler)this.tile, stack);
        if (!validate) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    @Nonnull
    public ItemStack insertOutputItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.output) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    @Override
    @Nonnull
    public ItemStack extractFromInput(int slot, int amount, boolean simulate) {
        return super.extractItem(slot, amount, simulate);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128473_("Size");
        return nbt;
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }
}

