/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.fluid;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.LongStream;
import javax.annotation.Nonnull;
import muramasa.antimatter.capability.IMachineHandler;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.tile.TileEntityBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import tesseract.TesseractGraphWrappers;

public class FluidTanks
implements IFluidHandler {
    private final FluidTank[] tanks;
    private final long totalCapacity;

    public static <T extends TileEntityBase<T>> FluidTanks create(T tile, ContentEvent contentEvent, UnaryOperator<Builder<T>> builder) {
        return ((Builder)builder.apply(new Builder<T>(tile, contentEvent))).build();
    }

    public FluidTanks(int tanks, long tankAmountInMB) {
        this.tanks = new FluidTank[tanks];
        for (int i = 0; i < tanks; ++i) {
            this.tanks[i] = new FluidTank(tankAmountInMB * TesseractGraphWrappers.dropletMultiplier);
        }
        this.totalCapacity = (long)tanks * tankAmountInMB * TesseractGraphWrappers.dropletMultiplier;
    }

    public FluidTanks(int tanks, long tankAmountInMB, Predicate<FluidStack> validator) {
        this.tanks = new FluidTank[tanks];
        for (int i = 0; i < tanks; ++i) {
            this.tanks[i] = new FluidTank(tankAmountInMB * TesseractGraphWrappers.dropletMultiplier, validator);
        }
        this.totalCapacity = (long)tanks * tankAmountInMB * TesseractGraphWrappers.dropletMultiplier;
    }

    public FluidTanks(long ... tankAmountsInMB) {
        this.tanks = new FluidTank[tankAmountsInMB.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(tankAmountsInMB[i] * TesseractGraphWrappers.dropletMultiplier);
        }
        this.totalCapacity = LongStream.of(tankAmountsInMB).sum() * TesseractGraphWrappers.dropletMultiplier;
    }

    public FluidTanks(Collection<FluidTank> tanks) {
        this.tanks = tanks.toArray(new FluidTank[0]);
        this.totalCapacity = tanks.stream().mapToLong(FluidTank::getCapacityInDroplets).sum();
    }

    public FluidTanks(FluidTank ... tanks) {
        this.tanks = tanks;
        this.totalCapacity = Arrays.stream(tanks).mapToLong(FluidTank::getCapacityInDroplets).sum();
    }

    public int getFirstAvailableTank(FluidStack stack, boolean drain) {
        int firstAvailable = -1;
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            if (tank.isEmpty()) {
                firstAvailable = i;
                break;
            }
            if ((!drain || tank.drain(stack, IFluidHandler.FluidAction.SIMULATE).isEmpty()) && (drain || tank.fillDroplets(stack, IFluidHandler.FluidAction.SIMULATE) == 0L)) continue;
            return i;
        }
        return firstAvailable;
    }

    public FluidTank getTank(int tank) {
        return this.tanks[tank];
    }

    public FluidStack[] getFluids() {
        return (FluidStack[])Arrays.stream(this.tanks).map(FluidTank::getFluid).toArray(FluidStack[]::new);
    }

    public FluidTank[] getBackingTanks() {
        return this.tanks;
    }

    public int getTanks() {
        return this.tanks.length;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.tanks[tank].getFluid();
    }

    public long getTankCapacityInDroplets(int tank) {
        return this.tanks[tank].getCapacityInDroplets();
    }

    public int getTankCapacity(int tank) {
        return (int)(this.getTankCapacityInDroplets(tank) / TesseractGraphWrappers.dropletMultiplier);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.tanks[tank].isFluidValid(stack);
    }

    public long getTotalFluidAmount() {
        long amount = 0L;
        for (FluidTank tank : this.tanks) {
            amount += tank.getFluidAmountInDroplets();
        }
        return amount;
    }

    public long getTotalCapacity() {
        return this.totalCapacity;
    }

    public long fillDroplets(FluidStack stack, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.tanks.length; ++i) {
            long fill = this.getTank(i).fillDroplets(stack, action);
            if (fill <= 0L) continue;
            return fill;
        }
        return 0L;
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        return (int)(this.fillDroplets(stack, action) / TesseractGraphWrappers.dropletMultiplier);
    }

    @Nonnull
    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidStack drain = this.getTank(i).drain(stack, action);
            if (drain.isEmpty()) continue;
            return drain;
        }
        return FluidStack.EMPTY;
    }

    public ListTag serializeNBT() {
        ListTag nbt = new ListTag();
        Arrays.stream(this.tanks).forEach(t -> nbt.add((Object)t.getFluid().writeToNBT(new CompoundTag())));
        return nbt;
    }

    public void deserializeNBT(ListTag nbt) {
        int i = 0;
        for (Tag tank : nbt) {
            if (!(tank instanceof CompoundTag)) continue;
            CompoundTag cnbt = (CompoundTag)tank;
            if (i > this.tanks.length - 1) break;
            this.tanks[i++].setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)cnbt));
        }
    }

    @Nonnull
    public FluidStack drain(long maxDrain, IFluidHandler.FluidAction action) {
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidTank tank = this.getTank(i);
            FluidStack stack = tank.drain(maxDrain, action);
            if (stack.isEmpty()) continue;
            return stack;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain((long)maxDrain * TesseractGraphWrappers.dropletMultiplier, action);
    }

    public static class Builder<T extends TileEntityBase> {
        private final T tile;
        private final List<FluidTank> tanks;
        private final ContentEvent contentEvent;

        private Builder(T tile, ContentEvent contentEvent) {
            this.tile = tile;
            this.tanks = new ObjectArrayList();
            this.contentEvent = contentEvent;
        }

        public Builder<T> tank(Predicate<FluidStack> validator, int amount) {
            this.tanks.add(new FluidTank(amount, validator){

                protected void onContentsChanged() {
                    ((IMachineHandler)tile).onMachineEvent(contentEvent, this.fluid);
                }
            });
            return this;
        }

        public Builder<T> tank(int amount) {
            this.tanks.add(new FluidTank(amount){

                protected void onContentsChanged() {
                    ((IMachineHandler)tile).onMachineEvent(contentEvent, this.fluid);
                }
            });
            return this;
        }

        private FluidTanks build() {
            return new FluidTanks(this.tanks);
        }
    }
}

