/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.fluid;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import tesseract.TesseractGraphWrappers;

public class FluidTankWrapper
implements IFluidHandler {
    private FluidTank[] tanks;
    private boolean dirty = false;
    private Set<Fluid>[] filter = new Set[]{new ObjectOpenHashSet(), new ObjectOpenHashSet(), new ObjectOpenHashSet(), new ObjectOpenHashSet(), new ObjectOpenHashSet(), new ObjectOpenHashSet()};

    public FluidTankWrapper(final TileEntityMachine machine, int count, int capacity, final ContentEvent event) {
        this.tanks = new FluidTank[count];
        for (int i = 0; i < count; ++i) {
            this.tanks[i] = new FluidTank(capacity){

                protected void onContentsChanged() {
                    FluidTankWrapper.this.dirty = true;
                    machine.onMachineEvent(event, new Object[0]);
                }
            };
        }
    }

    @Nonnull
    public FluidTank getTank(int tank) {
        return this.tanks[tank];
    }

    public int getTanks() {
        return this.tanks.length;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.tanks[tank].getFluid();
    }

    public void setFluidToTank(int tank, FluidStack stack) {
        this.tanks[tank].setFluid(stack);
    }

    @Nonnull
    public CompoundTag writeToNBT(int tank, CompoundTag nbt) {
        this.tanks[tank].writeToNBT(nbt);
        return nbt;
    }

    public long getTankCapacityInDroplets(int tank) {
        return this.tanks[tank].getCapacityInDroplets();
    }

    public int getTankCapacity(int tank) {
        return (int)(this.getTankCapacityInDroplets(tank) / TesseractGraphWrappers.dropletMultiplier);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.tanks[tank].isFluidValid(stack);
    }

    public long fillDroplets(FluidStack resource, IFluidHandler.FluidAction action) {
        int tank = this.getFirstValidTank(resource.getFluid());
        return tank != -1 ? this.getTank(tank).fillDroplets(resource, action) : 0L;
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        return (int)(this.fillDroplets(stack, action) / TesseractGraphWrappers.dropletMultiplier);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidTank tank = this.findFluidInTanks(resource);
        return tank != null ? tank.drain(resource, action) : FluidStack.EMPTY;
    }

    @Nonnull
    @Deprecated
    public FluidStack drain(long maxDrain, IFluidHandler.FluidAction action) {
        FluidTank tank = this.getFirstValidTank();
        return tank != null ? tank.drain(maxDrain, action) : FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        return this.drain((long)amount * TesseractGraphWrappers.dropletMultiplier, action);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isFluidAvailable(Object fluid, int dir) {
        Set<Fluid> filtered = this.filter[dir];
        return filtered.isEmpty() || filtered.contains(fluid);
    }

    public int getFirstValidTank(Object fluid) {
        int tank = -1;
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack stack = this.getFluidInTank(i);
            if (stack.isEmpty()) {
                tank = i;
                continue;
            }
            if (!stack.getFluid().equals(fluid) || this.getTankCapacityInDroplets(i) <= stack.getRealAmount()) continue;
            return i;
        }
        return tank;
    }

    public int getAvailableTank(int dir) {
        Set<Fluid> set = this.filter[dir];
        if (set.isEmpty()) {
            for (int i = 0; i < this.getTanks(); ++i) {
                FluidStack stack = this.getFluidInTank(i);
                if (stack.isEmpty()) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.getTanks(); ++i) {
                FluidStack stack = this.getFluidInTank(i);
                if (stack.isEmpty() || !set.contains(stack.getFluid())) continue;
                return i;
            }
        }
        return -1;
    }

    @Nullable
    private FluidTank findFluidInTanks(FluidStack fluid) {
        for (FluidTank tank : this.tanks) {
            if (tank.isEmpty() || !Utils.equals(tank.getFluid(), fluid)) continue;
            return tank;
        }
        return null;
    }

    @Nullable
    private FluidTank getFirstValidTank() {
        for (FluidTank tank : this.tanks) {
            if (tank.isEmpty()) continue;
            return tank;
        }
        return null;
    }

    @Nullable
    private FluidTank getFirstEmptyTank() {
        for (FluidTank tank : this.tanks) {
            if (tank.isEmpty()) continue;
            return tank;
        }
        return null;
    }
}

