/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.fluid;

import javax.annotation.Nonnull;
import muramasa.antimatter.capability.CoverHandler;
import muramasa.antimatter.capability.FluidHandler;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import tesseract.TesseractGraphWrappers;
import tesseract.api.fluid.IFluidNode;

public class FluidHandlerSidedWrapper
implements IFluidNode {
    protected FluidHandler<?> fluidHandler;
    protected Direction side;
    CoverHandler<?> coverHandler;

    public FluidHandlerSidedWrapper(FluidHandler<?> fluidHandler, CoverHandler<?> coverHandler, Direction side) {
        this.fluidHandler = fluidHandler;
        this.coverHandler = coverHandler;
        this.side = side;
    }

    public int getTanks() {
        return this.fluidHandler.getTanks();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidHandler.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.fluidHandler.getTankCapacity(tank);
    }

    public long getTankCapacityInDroplets(int tank) {
        return this.fluidHandler.getTankCapacityInDroplets(tank);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.fluidHandler.isFluidValid(tank, stack);
    }

    public long fillDroplets(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.coverHandler != null && this.coverHandler.get(this.side).blocksInput(IFluidHandler.class, this.side)) {
            return 0L;
        }
        if (!this.fluidHandler.canInput(resource, this.side) || !this.fluidHandler.canInput(this.side)) {
            return 0L;
        }
        return this.fluidHandler.fillDroplets(resource, action);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return (int)(this.fillDroplets(resource, action) / TesseractGraphWrappers.dropletMultiplier);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.coverHandler != null && this.coverHandler.get(this.side).blocksOutput(IFluidHandler.class, this.side)) {
            return FluidStack.EMPTY;
        }
        if (!this.fluidHandler.canOutput(this.side)) {
            return FluidStack.EMPTY;
        }
        return this.fluidHandler.drain(resource, action);
    }

    @Nonnull
    public FluidStack drain(long maxDrain, IFluidHandler.FluidAction action) {
        if (this.coverHandler != null && this.coverHandler.get(this.side).blocksOutput(IFluidHandler.class, this.side)) {
            return FluidStack.EMPTY;
        }
        if (!this.fluidHandler.canOutput(this.side)) {
            return FluidStack.EMPTY;
        }
        return this.fluidHandler.drain(maxDrain, action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain((long)maxDrain * TesseractGraphWrappers.dropletMultiplier, action);
    }

    public int getPriority(Direction direction) {
        return this.fluidHandler.getPriority(direction);
    }

    public boolean canOutput() {
        return this.fluidHandler.canOutput();
    }

    public boolean canInput() {
        return this.fluidHandler.canInput();
    }

    public boolean canInput(Direction direction) {
        return this.fluidHandler.canInput(direction);
    }

    public boolean canOutput(Direction direction) {
        return this.fluidHandler.canOutput(direction);
    }

    public boolean canInput(FluidStack fluid, Direction direction) {
        return this.fluidHandler.canInput(fluid, direction);
    }
}

