/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability.energy;

import muramasa.antimatter.capability.EnergyHandler;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import tesseract.api.context.TesseractItemContext;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandlerItem;

public class ItemEnergyHandler
extends EnergyHandler
implements IEnergyHandlerItem {
    protected boolean discharge = true;
    protected long maxEnergy;
    protected TesseractItemContext context;

    public ItemEnergyHandler(TesseractItemContext context, long capacity, int voltageIn, int voltageOut, int amperageIn, int amperageOut) {
        super(0L, capacity, voltageIn, voltageOut, amperageIn, amperageOut);
        this.maxEnergy = capacity;
        this.context = context;
        if (AntimatterPlatformUtils.isFabric()) {
            this.readFromContextOnFabric();
        }
    }

    private void readFromContextOnFabric() {
        CompoundTag nbt = this.context.getTag();
        if (!nbt.m_128441_("ied")) {
            return;
        }
        CompoundTag energyTag = nbt.m_128469_("ied");
        if (energyTag.m_128441_("e")) {
            this.energy = energyTag.m_128454_("e");
        }
        if (energyTag.m_128441_("me")) {
            this.energy = energyTag.m_128454_("me");
        }
        if (energyTag.m_128441_("idm")) {
            this.discharge = energyTag.m_128471_("idm");
        }
    }

    @Override
    public long getEnergy() {
        CompoundTag nbt = this.context.getTag();
        if (!nbt.m_128441_("ied")) {
            return 0L;
        }
        CompoundTag energyTag = nbt.m_128469_("ied");
        return energyTag.m_128454_("e");
    }

    @Override
    public long getCapacity() {
        CompoundTag nbt = this.context.getTag();
        if (!nbt.m_128441_("ied")) {
            return this.capacity;
        }
        CompoundTag energyTag = nbt.m_128469_("ied");
        if (!energyTag.m_128441_("me")) {
            return this.capacity;
        }
        return energyTag.m_128454_("me");
    }

    @Override
    public boolean canInput() {
        return this.voltageIn > 0L;
    }

    @Override
    public boolean canOutput() {
        return this.canDischarge() && this.voltageOut > 0L;
    }

    private boolean canDischarge() {
        CompoundTag nbt = this.context.getTag();
        if (!nbt.m_128441_("ied")) {
            return true;
        }
        CompoundTag energyTag = nbt.m_128469_("ied");
        if (!energyTag.m_128441_("me")) {
            return true;
        }
        return energyTag.m_128471_("idm");
    }

    public boolean chargeModeSwitch() {
        boolean discharge = !this.canDischarge();
        CompoundTag energyTag = this.getContainer().getOrCreateTagElement("ied");
        energyTag.m_128379_("idm", discharge);
        return discharge;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
        CompoundTag energyTag = this.getContainer().getOrCreateTagElement("ied");
        energyTag.m_128356_("e", energy);
    }

    public void setCapacity(long capacity) {
        this.maxEnergy = capacity;
        CompoundTag energyTag = this.getContainer().getOrCreateTagElement("ied");
        energyTag.m_128356_("me", capacity);
    }

    @Override
    public boolean addEnergy(GTTransaction.TransferData data) {
        if (!this.canInput()) {
            return false;
        }
        if (data.transaction.mode == GTTransaction.Mode.TRANSMIT) {
            boolean ok = this.checkVoltage(data);
            if (!ok) {
                return false;
            }
            long amps = Math.min(data.getAmps(true), this.availableAmpsInput());
            amps = Math.min(amps, (this.getCapacity() - this.getEnergy()) / this.getInputVoltage());
            long energy = data.getEnergy(amps, true);
            this.setEnergy(this.getEnergy() + energy);
            data.useAmps(true, amps);
            this.getState().receive(false, amps);
            return amps > 0L;
        }
        long toAdd = Math.min(data.getEu(), this.getCapacity() - this.getEnergy());
        long energy = data.drainEu(toAdd);
        this.setEnergy(this.getEnergy() + energy);
        return toAdd > 0L;
    }

    @Override
    public boolean extractEnergy(GTTransaction.TransferData data) {
        if (data.transaction.mode == GTTransaction.Mode.TRANSMIT) {
            long amps = Math.min(data.getAmps(false), this.availableAmpsOutput());
            amps = Math.min(amps, this.getEnergy() / this.getOutputVoltage());
            long energy = data.getEnergy(amps, false);
            this.setEnergy(this.getEnergy() - energy);
            this.getState().extract(false, amps);
            data.useAmps(false, amps);
            return amps > 0L;
        }
        long toDrain = Math.min(data.getEu(), this.getEnergy());
        long energy = data.drainEu(toDrain);
        this.setEnergy(this.getEnergy() - energy);
        return toDrain > 0L;
    }

    @NotNull
    public TesseractItemContext getContainer() {
        return this.context;
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        nbt.m_128356_("e", this.energy);
        nbt.m_128356_("me", this.maxEnergy);
        nbt.m_128379_("idm", this.discharge);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.energy = nbt.m_128441_("ie") ? nbt.m_128454_("ie") : nbt.m_128454_("e");
        this.maxEnergy = nbt.m_128454_("me");
        this.discharge = nbt.m_128471_("idm");
    }
}

