/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.capability.IMachineHandler;
import muramasa.antimatter.capability.fluid.FluidTanks;
import muramasa.antimatter.machine.event.ContentEvent;
import muramasa.antimatter.machine.event.IMachineEvent;
import muramasa.antimatter.tile.TileEntityBase;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import tesseract.FluidPlatformUtils;
import tesseract.TesseractGraphWrappers;
import tesseract.api.fluid.IFluidNode;

public abstract class FluidHandler<T extends TileEntityBase>
implements IMachineHandler,
IFluidNode {
    protected final T tile;
    protected final EnumMap<FluidDirection, FluidTanks> tanks = new EnumMap(FluidDirection.class);
    protected int capacity;
    protected int pressure;
    protected boolean dirty;

    public FluidHandler(T tile, int capacity, int pressure, int inputCount, int outputCount) {
        this.tile = tile;
        this.capacity = capacity;
        this.pressure = pressure;
        if (inputCount > 0) {
            this.tanks.put(FluidDirection.INPUT, FluidTanks.create(tile, ContentEvent.FLUID_INPUT_CHANGED, b -> {
                for (int i = 0; i < inputCount; ++i) {
                    b.tank(capacity);
                }
                return b;
            }));
        }
        if (outputCount > 0) {
            this.tanks.put(FluidDirection.OUTPUT, FluidTanks.create(tile, ContentEvent.FLUID_OUTPUT_CHANGED, b -> {
                for (int i = 0; i < outputCount; ++i) {
                    b.tank(capacity);
                }
                return b;
            }));
        }
    }

    public void onRemove() {
    }

    public void onReset() {
    }

    public void onUpdate() {
    }

    public int getTanks() {
        return this.tanks.values().stream().mapToInt(FluidTanks::getTanks).sum();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getTank(tank).getFluid();
    }

    protected FluidTank getTank(int tank) {
        FluidTanks tanks = this.getTanks(tank);
        if (tanks == null) {
            return null;
        }
        return tanks.getTank(this.offsetTank(tank));
    }

    protected FluidTanks getTanks(int tank) {
        boolean isOutput;
        boolean hasOutput;
        FluidTanks input = this.getInputTanks();
        FluidTanks output = this.getOutputTanks();
        boolean hasInput = input != null;
        boolean bl = hasOutput = output != null;
        if (hasInput && !hasOutput) {
            return input;
        }
        if (!hasInput && hasOutput) {
            return output;
        }
        if (!hasOutput && !hasOutput) {
            return null;
        }
        boolean bl2 = isOutput = tank >= input.getTanks();
        if (!isOutput) {
            return input;
        }
        return output;
    }

    protected int offsetTank(int tank) {
        FluidTanks in = this.getInputTanks();
        if (in != null && tank >= this.getInputTanks().getTanks()) {
            return tank - in.getTanks();
        }
        return tank;
    }

    public long getTankCapacityInDroplets(int tank) {
        return this.getTanks(tank).getTankCapacityInDroplets(this.offsetTank(tank));
    }

    public int getTankCapacity(int tank) {
        return (int)(this.getTankCapacityInDroplets(tank) / TesseractGraphWrappers.dropletMultiplier);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.getTank(tank).isFluidValid(stack);
    }

    public FluidTanks getAllTanks() {
        ObjectArrayList list = new ObjectArrayList();
        if (this.getInputTanks() != null) {
            list.addAll(Arrays.asList(this.getInputTanks().getBackingTanks()));
        }
        if (this.getOutputTanks() != null) {
            list.addAll(Arrays.asList(this.getOutputTanks().getBackingTanks()));
        }
        return new FluidTanks((Collection<FluidTank>)list);
    }

    public long fillDroplets(FluidStack stack, IFluidHandler.FluidAction action) {
        FluidTanks input = this.getInputTanks();
        if (input != null && !this.empty(input)) {
            return this.getInputTanks().fillDroplets(stack, action);
        }
        return 0L;
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        return (int)(this.fillDroplets(stack, action) / TesseractGraphWrappers.dropletMultiplier);
    }

    protected boolean empty(FluidTanks tank) {
        return tank.getTanks() == 0;
    }

    public long fillOutput(FluidStack stack, IFluidHandler.FluidAction action) {
        if (this.getOutputTanks() != null) {
            return this.getOutputTanks().fillDroplets(stack, action);
        }
        return 0L;
    }

    @Nonnull
    public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        if (this.getOutputTanks() != null) {
            return this.getOutputTanks().drain(stack, action);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drainInput(FluidStack stack, IFluidHandler.FluidAction action) {
        if (this.getInputTanks() != null) {
            return this.getInputTanks().drain(stack, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drainInput(long maxDrain, IFluidHandler.FluidAction action) {
        if (this.getInputTanks() == null) {
            return FluidStack.EMPTY;
        }
        return this.getInputTanks().drain(maxDrain, action);
    }

    @Nonnull
    public FluidStack drain(long maxDrain, IFluidHandler.FluidAction action) {
        if (this.getOutputTanks() != null) {
            return this.getOutputTanks().drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        return this.drain((long)amount * TesseractGraphWrappers.dropletMultiplier, action);
    }

    protected boolean checkValidFluid(FluidStack fluid) {
        return true;
    }

    @Override
    public void onMachineEvent(IMachineEvent event, Object ... data) {
    }

    @Nonnull
    public FluidStack[] getInputs() {
        FluidTanks tanks = this.getInputTanks();
        return tanks == null ? new FluidStack[]{} : tanks.getFluids();
    }

    public FluidStack[] getOutputs() {
        FluidTanks tanks = this.getOutputTanks();
        return tanks == null ? new FluidStack[]{} : tanks.getFluids();
    }

    @Nullable
    public FluidTanks getInputTanks() {
        return this.tanks.get((Object)FluidDirection.INPUT);
    }

    @Nullable
    public FluidTanks getOutputTanks() {
        return this.tanks.get((Object)FluidDirection.OUTPUT);
    }

    public boolean canOutput() {
        return this.getOutputTanks() != null;
    }

    public boolean canInput() {
        return this.getInputTanks() != null;
    }

    public boolean canInput(Direction direction) {
        return this.canInput();
    }

    public boolean canInput(FluidStack fluid, Direction direction) {
        return true;
    }

    public boolean canOutput(Direction direction) {
        return this.canOutput();
    }

    public int getPriority(Direction direction) {
        return 0;
    }

    public String toString() {
        FluidStack stack;
        int i;
        StringBuilder builder = new StringBuilder();
        if (this.tanks.containsKey((Object)FluidDirection.INPUT)) {
            builder.append("Inputs:\n");
            for (i = 0; i < this.getInputTanks().getTanks(); ++i) {
                stack = this.getInputTanks().getFluidInTank(i);
                if (stack == FluidStack.EMPTY) continue;
                builder.append(FluidPlatformUtils.getFluidId((Fluid)stack.getFluid())).append(" - ").append(stack.getAmount());
                if (i == this.getInputTanks().getTanks() - 1) continue;
                builder.append("\n");
            }
        }
        if (this.tanks.containsKey((Object)FluidDirection.OUTPUT)) {
            builder.append("Outputs:\n");
            for (i = 0; i < this.getOutputTanks().getTanks(); ++i) {
                stack = this.getOutputTanks().getFluidInTank(i);
                if (stack == FluidStack.EMPTY) continue;
                builder.append(FluidPlatformUtils.getFluidId((Fluid)stack.getFluid())).append(" - ").append(stack.getAmount());
                if (i == this.getOutputTanks().getTanks() - 1) continue;
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.tanks.forEach((k, v) -> {
            if (!nbt.m_128441_(k.toString())) {
                return;
            }
            v.deserializeNBT(nbt.m_128437_(k.toString(), 10));
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        this.tanks.forEach((k, v) -> nbt.m_128365_(k.name(), (Tag)v.serializeNBT()));
        return nbt;
    }

    public static enum FluidDirection {
        INPUT,
        OUTPUT;

    }
}

