/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import tesseract.api.gt.GTConsumer;
import tesseract.api.gt.GTTransaction;
import tesseract.api.gt.IEnergyHandler;
import tesseract.api.gt.IGTNode;

public class EnergyHandler
implements IEnergyHandler {
    protected final long capacity;
    protected long energy;
    protected long voltageIn;
    protected long voltageOut;
    protected long amperageIn;
    protected long amperageOut;
    protected GTConsumer.State state = new GTConsumer.State((IGTNode)this);

    public EnergyHandler(long energy, long capacity, int voltageIn, int voltageOut, int amperageIn, int amperageOut) {
        this.energy = energy;
        this.capacity = capacity;
        this.voltageIn = voltageIn;
        this.voltageOut = voltageOut;
        this.amperageIn = amperageIn;
        this.amperageOut = amperageOut;
    }

    protected boolean checkVoltage(GTTransaction.TransferData data) {
        return true;
    }

    public void onUpdate() {
        this.state.onTick();
    }

    public void setOutputAmperage(long amperageOut) {
        this.amperageOut = amperageOut;
    }

    public void setInputAmperage(long amperageIn) {
        this.amperageIn = amperageIn;
    }

    public void setOutputVoltage(long voltageOut) {
        this.voltageOut = voltageOut;
    }

    public void setInputVoltage(long voltageIn) {
        this.voltageIn = voltageIn;
    }

    public boolean extractEnergy(GTTransaction.TransferData data) {
        if (data.transaction.mode == GTTransaction.Mode.TRANSMIT) {
            long amps = Math.min(data.getAmps(false), this.availableAmpsOutput());
            amps = Math.min(amps, this.energy / this.getOutputVoltage());
            this.energy -= data.getEnergy(amps, false);
            this.getState().extract(false, amps);
            data.useAmps(false, amps);
            return amps > 0L;
        }
        long toDrain = Math.min(data.getEu(), this.energy);
        this.energy -= data.drainEu(toDrain);
        return toDrain > 0L;
    }

    protected void overVolt() {
    }

    public boolean addEnergy(GTTransaction.TransferData data) {
        if (data.transaction.mode == GTTransaction.Mode.TRANSMIT) {
            boolean ok = this.checkVoltage(data);
            if (!ok) {
                return false;
            }
            long amps = Math.min(data.getAmps(true), this.availableAmpsInput());
            amps = Math.min(amps, (this.capacity - this.energy) / this.getInputVoltage());
            this.energy += data.getEnergy(amps, true);
            data.useAmps(true, amps);
            this.getState().receive(false, amps);
            return amps > 0L;
        }
        long toAdd = Math.min(data.getEu(), this.capacity - this.energy);
        this.energy += data.drainEu(toAdd);
        return toAdd > 0L;
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getInputAmperage() {
        return this.amperageIn;
    }

    public long getOutputAmperage() {
        return this.amperageOut;
    }

    public long getInputVoltage() {
        return this.voltageIn;
    }

    public long getOutputVoltage() {
        return this.voltageOut;
    }

    public boolean canInput() {
        return this.voltageIn > 0L;
    }

    public boolean canInput(Direction direction) {
        return this.canInput();
    }

    public boolean canOutput(Direction direction) {
        return this.canOutput();
    }

    public boolean canOutput() {
        return this.voltageOut > 0L;
    }

    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128356_("me", this.energy);
        tag.m_128356_("vi", this.voltageIn);
        tag.m_128356_("vo", this.voltageOut);
        tag.m_128356_("ai", this.amperageIn);
        tag.m_128356_("ao", this.amperageOut);
        return tag;
    }

    public void deserialize(CompoundTag nbt) {
        this.energy = nbt.m_128454_("me");
        this.voltageIn = nbt.m_128454_("vi");
        this.voltageOut = nbt.m_128454_("vo");
        this.amperageIn = nbt.m_128454_("ai");
        this.amperageOut = nbt.m_128454_("ao");
    }

    public GTConsumer.State getState() {
        return this.state;
    }
}

