/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import muramasa.antimatter.capability.Holder;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;

public class Dispatch {
    private final Map<Class<?>, Holder<?, ?>> capabilityHolderMap = new Object2ObjectOpenHashMap();

    public void registerHolder(Holder holder) {
        this.capabilityHolderMap.put(holder.cap, holder);
    }

    public Dispatch invalidate() {
        for (Holder<?, ?> value : this.capabilityHolderMap.values()) {
            value.invalidate();
        }
        return this;
    }

    public Dispatch invalidate(Direction side) {
        for (Holder<?, ?> value : this.capabilityHolderMap.values()) {
            value.invalidate(side);
        }
        return this;
    }

    public Dispatch invalidate(Class<?> cap) {
        this.capabilityHolderMap.get(cap).invalidate();
        return this;
    }

    public Dispatch invalidate(Class<?> cap, Direction side) {
        this.capabilityHolderMap.get(cap).invalidate(side);
        return this;
    }

    public Holder<?, ?> getHolder(Class<?> cap) {
        return this.capabilityHolderMap.get(cap);
    }

    public static interface Sided<U> {
        public LazyOptional<? extends U> forSide(Direction var1);

        default public LazyOptional<? extends U> forNullSide() {
            return LazyOptional.empty();
        }
    }
}

