/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.capability;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import muramasa.antimatter.capability.IComponentHandler;
import muramasa.antimatter.capability.machine.MachineEnergyHandler;
import muramasa.antimatter.capability.machine.MachineFluidHandler;
import muramasa.antimatter.capability.machine.MachineItemHandler;
import muramasa.antimatter.structure.StructureCache;
import muramasa.antimatter.tile.TileEntityBase;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tile.multi.TileEntityMultiMachine;

public class ComponentHandler<T extends TileEntityBase<T>>
implements IComponentHandler {
    protected String componentId;
    protected T componentTile;
    protected Set<TileEntityMultiMachine<?>> controllers = new ObjectOpenHashSet();

    public ComponentHandler(String componentId, T componentTile) {
        this.componentId = componentId;
        this.componentTile = componentTile;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.componentId;
    }

    @Nonnull
    public T getTile() {
        return this.componentTile;
    }

    @Override
    @Nonnull
    public Optional<MachineItemHandler<?>> getItemHandler() {
        return this.componentTile instanceof TileEntityMachine ? Optional.of(((TileEntityMachine)this.componentTile).itemHandler.get()) : Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<MachineFluidHandler<?>> getFluidHandler() {
        return this.componentTile instanceof TileEntityMachine ? Optional.of(((TileEntityMachine)this.componentTile).fluidHandler.get()) : Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<MachineEnergyHandler<?>> getEnergyHandler() {
        return this.componentTile instanceof TileEntityMachine ? Optional.of(((TileEntityMachine)this.componentTile).energyHandler.get()) : Optional.empty();
    }

    @Override
    public void onStructureFormed(@Nonnull TileEntityMultiMachine<?> controllerTile) {
        this.controllers.add(controllerTile);
    }

    @Override
    public void onStructureInvalidated(@Nonnull TileEntityMultiMachine<?> controllerTile) {
        this.controllers.remove(controllerTile);
    }

    @Override
    public boolean hasLinkedController() {
        return StructureCache.has(this.getTile().m_58904_(), this.getTile().m_58899_());
    }

    @Override
    @Nonnull
    public Collection<TileEntityMultiMachine<?>> getControllers() {
        return this.controllers;
    }
}

