/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.block;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.builder.AntimatterItemModelBuilder;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.dynamic.BlockDynamic;
import muramasa.antimatter.dynamic.ModelConfig;
import muramasa.antimatter.dynamic.ModelConfigRandom;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.registration.IColorHandler;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.texture.Texture;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BlockSurfaceRock
extends BlockDynamic
implements SimpleWaterloggedBlock,
ISharedAntimatterObject,
IColorHandler {
    protected static final int SURFACE_ROCK_MODEL_COUNT = 7;
    protected static final int[] CONFIG_ARRAY = new int[7];
    protected Material material;
    protected StoneType stoneType;
    protected final ImmutableMap<String, Texture> textureMap;

    public BlockSurfaceRock(String domain, Material material, StoneType stoneType) {
        super(domain, "surface_rock_" + material.getId() + "_" + stoneType.getId(), BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76310_).m_60913_(1.0f, 1.0f).m_60918_(SoundType.f_56742_).m_60910_().m_60955_());
        this.material = material;
        this.stoneType = stoneType;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        this.config = new ModelConfigRandom().set(new BlockPos(0, 0, 0), CONFIG_ARRAY);
        this.shapes.put(0, (Object)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0));
        this.shapes.put(1, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)3.0, (double)10.0));
        this.shapes.put(2, (Object)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)10.0, (double)1.0, (double)10.0));
        this.shapes.put(3, (Object)Block.m_49796_((double)7.0, (double)0.0, (double)8.0, (double)13.0, (double)1.0, (double)12.0));
        this.shapes.put(4, (Object)Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)11.0, (double)3.0, (double)9.0));
        this.shapes.put(5, (Object)Block.m_49796_((double)9.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)8.0));
        this.shapes.put(6, (Object)Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)8.0));
        this.textureMap = ImmutableMap.of((Object)"all", (Object)((Object)stoneType.getTexture()), (Object)"overlay", (Object)((Object)new Texture("antimatter", "material/rock_overlay")));
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (AntimatterMaterialTypes.ROCK.isVisible()) {
            items.add((Object)new ItemStack((ItemLike)this));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        super.m_6861_(state, world, pos, block, fromPos, moving);
        if (fromPos.m_7494_().equals((Object)pos) && !world.m_8055_(fromPos).m_60815_() && !world.f_46443_) {
            Utils.breakBlock(world, null, ItemStack.f_41583_, pos, 0);
        }
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        return i == 1 ? this.material.getRGB() : -1;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult traceResult) {
        if (player.m_6047_()) {
            return InteractionResult.FAIL;
        }
        this.m_6240_(world, player, pos, state, world.m_7702_(pos), player.m_21120_(hand));
        BlockSurfaceRock.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)ItemStack.f_41583_);
        if (!player.m_36356_(AntimatterMaterialTypes.ROCK.get(this.material, 1))) {
            Containers.m_19010_((Level)world, (BlockPos)pos, (NonNullList)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{AntimatterMaterialTypes.ROCK.get(this.material, 1)}));
        }
        world.m_7471_(pos, true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public ModelConfig getConfig(BlockState state, BlockGetter world, BlockPos.MutableBlockPos mut, BlockPos pos) {
        return this.config.set(pos, this.config.getConfig());
    }

    @Override
    public void onBlockModelBuild(Block block, AntimatterBlockStateProvider prov) {
        AntimatterBlockModelBuilder builder = prov.getBuilder(block);
        builder.model("antimatter:block/rock/surface_rock_0", this.textureMap);
        IntStream.range(0, 7).forEach(i -> builder.config(i, "antimatter:block/rock/surface_rock_" + i, c -> c.tex(this.textureMap)));
        prov.state(block, builder);
    }

    @Override
    public void onItemModelBuild(ItemLike item, AntimatterItemModelProvider prov) {
        ((AntimatterItemModelBuilder)prov.getBuilder(item).parent(prov.existing("antimatter", "block/rock/surface_rock_0"))).tex((Map<String, Texture>)this.textureMap);
    }

    @Override
    public List<String> getInfo(List<String> info, Level world, BlockState state, BlockPos pos) {
        super.getInfo(info, world, state, pos);
        info.add("Material: " + this.material.getId());
        info.add("StoneType: " + this.stoneType.getId());
        return info;
    }

    public Material getMaterial() {
        return this.material;
    }

    public StoneType getStoneType() {
        return this.stoneType;
    }

    static {
        IntStream.range(0, 7).forEach(i -> {
            BlockSurfaceRock.CONFIG_ARRAY[i] = i;
        });
    }
}

