/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.block;

import java.util.Map;
import javax.annotation.Nullable;
import muramasa.antimatter.block.AntimatterItemBlock;
import muramasa.antimatter.block.BlockMaterialType;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialTags;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.registration.IItemBlockProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockStorage
extends BlockMaterialType
implements IItemBlockProvider,
ISharedAntimatterObject {
    private static final VoxelShape FRAME_SHAPE = Shapes.m_83048_((double)0.05, (double)0.0, (double)0.05, (double)0.95, (double)1.0, (double)0.95);

    public BlockStorage(String domain, MaterialType<?> type, Material material) {
        super(domain, material, type, BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76279_).m_60978_(8.0f).m_60918_(SoundType.f_56743_));
    }

    @Override
    public AntimatterItemBlock getItemBlock() {
        return new AntimatterItemBlock(this){

            @Nullable
            public BlockPlaceContext m_7732_(BlockPlaceContext ctx) {
                if (ctx.m_43723_().m_6047_()) {
                    return ctx;
                }
                BlockPos actualPos = ctx.m_8083_().m_142300_(ctx.m_43719_().m_122424_());
                BlockState state = ctx.m_43725_().m_8055_(actualPos);
                if (!state.m_204336_(AntimatterMaterialTypes.FRAME.getTag())) {
                    return ctx;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(actualPos.m_123341_(), actualPos.m_123342_(), actualPos.m_123343_());
                while (ctx.m_43725_().m_151558_() > mutablePos.m_123342_() + 1) {
                    if (!ctx.m_43725_().m_8055_((BlockPos)mutablePos.m_122173_(Direction.UP)).m_60629_(ctx)) continue;
                    ctx.m_43723_().m_6674_(ctx.m_43724_());
                    ctx.m_43725_().m_46597_((BlockPos)mutablePos, ((BlockItem)ctx.m_43722_().m_41720_()).m_40614_().m_49966_());
                    if (!ctx.m_43723_().m_7500_()) {
                        ctx.m_43722_().m_41774_(1);
                    }
                    ctx.m_43725_().m_5594_(ctx.m_43723_(), (BlockPos)mutablePos, BlockStorage.this.f_60446_.m_56777_(), SoundSource.BLOCKS, (BlockStorage.this.f_60446_.m_56773_() + 1.0f) / 2.0f, BlockStorage.this.f_60446_.m_56774_() * 0.8f);
                    return null;
                }
                return ctx;
            }

            public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
                Integer burnTime;
                Map<MaterialType<?>, Integer> map = MaterialTags.FURNACE_FUELS.getMap(BlockStorage.this.material);
                if (map != null && (burnTime = map.get(BlockStorage.this.type)) != null) {
                    return burnTime;
                }
                return -1;
            }
        };
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (this.type == AntimatterMaterialTypes.BLOCK) {
            return;
        }
        entity.m_20334_(Mth.m_14008_((double)entity.m_20184_().f_82479_, (double)-0.15, (double)0.15), entity.m_20184_().f_82480_, Mth.m_14008_((double)entity.m_20184_().f_82481_, (double)-0.15, (double)0.15));
        entity.f_19789_ = 0.0f;
        if (entity.m_6047_() && entity instanceof Player) {
            if (entity.m_20069_()) {
                entity.m_20334_(entity.m_20184_().f_82479_, 0.02, entity.m_20184_().f_82481_);
            } else {
                entity.m_20334_(entity.m_20184_().f_82479_, 0.08, entity.m_20184_().f_82481_);
            }
        } else if (entity.f_19862_) {
            float toolSpeed = this.material.has(MaterialTags.TOOLS) ? MaterialTags.TOOLS.get(this.material).toolSpeed() : 0.0f;
            entity.m_20334_(entity.m_20184_().f_82479_, 0.22 + (double)(toolSpeed / 75.0f), entity.m_20184_().f_82481_);
        } else {
            entity.m_20334_(entity.m_20184_().f_82479_, Math.max(entity.m_20184_().f_82480_, -0.2), entity.m_20184_().f_82481_);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (context != CollisionContext.m_82749_()) {
            return super.m_5940_(state, world, pos, context);
        }
        return this.type == AntimatterMaterialTypes.FRAME ? FRAME_SHAPE : super.m_5940_(state, world, pos, context);
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return this.type == AntimatterMaterialTypes.FRAME;
    }

    public PushReaction m_5537_(BlockState state) {
        return this.type == AntimatterMaterialTypes.FRAME ? PushReaction.DESTROY : PushReaction.NORMAL;
    }
}

