/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.block;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.builder.AntimatterItemModelBuilder;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.registration.IModelProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.ITextureProvider;
import muramasa.antimatter.texture.Texture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Material;

public class BlockStoneWall
extends WallBlock
implements ISharedAntimatterObject,
ITextureProvider,
IModelProvider {
    protected String domain;
    protected String id;
    protected String suffix;
    CobbleStoneType type;

    public BlockStoneWall(CobbleStoneType type, String suffix) {
        super(BlockStoneWall.getProps(type));
        this.domain = type.getDomain();
        this.id = type.getId() + "_" + suffix + "_wall";
        this.suffix = suffix;
        this.type = type;
        AntimatterAPI.register(this.getClass(), this);
    }

    private static BlockBehaviour.Properties getProps(StoneType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)type.getBlockMaterial()).m_60918_(type.getSoundType()).m_60913_(type.getHardness(), type.getResistence());
        if (type.doesRequireTool()) {
            props.m_60999_();
        }
        return props;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.type.getDomain(), this.type.getBeginningPath() + this.type.getId() + "/" + (this.suffix.isEmpty() ? "stone" : this.suffix))};
    }

    @Override
    public void onItemModelBuild(ItemLike item, AntimatterItemModelProvider prov) {
        ((AntimatterItemModelBuilder)prov.getBuilder(item).parent(new ResourceLocation("minecraft", "block/wall_inventory"))).texture("wall", this.getTextures()[0]);
    }

    @Override
    public void onBlockModelBuild(Block block, AntimatterBlockStateProvider prov) {
        AntimatterBlockModelBuilder post = (AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)prov.models().getBuilder(this.getId() + "_post")).parent(prov.existing("minecraft", "block/template_wall_post"))).texture("wall", this.getTextures()[0]);
        AntimatterBlockModelBuilder side = (AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)prov.models().getBuilder(this.getId() + "_side")).parent(prov.existing("minecraft", "block/template_wall_side"))).texture("wall", this.getTextures()[0]);
        AntimatterBlockModelBuilder side_tall = (AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)prov.models().getBuilder(this.getId() + "_side_tall")).parent(prov.existing("minecraft", "block/template_wall_side_tall"))).texture("wall", this.getTextures()[0]);
        prov.getMultipartBuilder(block).part().modelFile(post).addModel().condition((Property)f_57949_, new Boolean[]{true}).end().part().modelFile(side).uvLock().addModel().condition((Property)f_57951_, (Comparable[])new WallSide[]{WallSide.LOW}).end().part().modelFile(side).rotationY(90).uvLock().addModel().condition((Property)f_57950_, (Comparable[])new WallSide[]{WallSide.LOW}).end().part().modelFile(side).rotationY(180).uvLock().addModel().condition((Property)f_57952_, (Comparable[])new WallSide[]{WallSide.LOW}).end().part().modelFile(side).rotationY(270).uvLock().addModel().condition((Property)f_57953_, (Comparable[])new WallSide[]{WallSide.LOW}).end().part().modelFile(side_tall).uvLock().addModel().condition((Property)f_57951_, (Comparable[])new WallSide[]{WallSide.TALL}).end().part().modelFile(side_tall).rotationY(90).uvLock().addModel().condition((Property)f_57950_, (Comparable[])new WallSide[]{WallSide.TALL}).end().part().modelFile(side_tall).rotationY(180).uvLock().addModel().condition((Property)f_57952_, (Comparable[])new WallSide[]{WallSide.TALL}).end().part().modelFile(side_tall).rotationY(270).uvLock().addModel().condition((Property)f_57953_, (Comparable[])new WallSide[]{WallSide.TALL}).end();
    }
}

