/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.block;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.builder.VariantBlockStateBuilder;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.registration.IModelProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.ITextureProvider;
import muramasa.antimatter.texture.Texture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Material;

public class BlockStoneSlab
extends SlabBlock
implements ISharedAntimatterObject,
ITextureProvider,
IModelProvider {
    protected String domain;
    protected String id;
    protected String suffix;
    CobbleStoneType type;

    public BlockStoneSlab(CobbleStoneType type, String suffix) {
        super(BlockStoneSlab.getProps(type));
        this.domain = type.getDomain();
        String s = suffix.isEmpty() ? "" : "_";
        this.id = type.getId() + s + suffix + "_slab";
        this.suffix = suffix;
        this.type = type;
        AntimatterAPI.register(this.getClass(), this);
    }

    private static BlockBehaviour.Properties getProps(StoneType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)type.getBlockMaterial()).m_60918_(type.getSoundType()).m_60913_(type.getHardness(), type.getResistence());
        if (type.doesRequireTool()) {
            props.m_60999_();
        }
        return props;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Texture[] getTextures() {
        return new Texture[]{new Texture(this.type.getDomain(), this.type.getBeginningPath() + this.type.getId() + "/" + (this.suffix.isEmpty() ? "stone" : this.suffix))};
    }

    @Override
    public void onBlockModelBuild(Block block, AntimatterBlockStateProvider prov) {
        Texture sideTexture;
        Texture bottomTexture = sideTexture = this.getTextures()[0];
        Texture topTexture = sideTexture;
        ResourceLocation both = prov.existing(this.getDomain(), "block/" + this.getId().replace("_slab", ""));
        if (this.type == AntimatterStoneTypes.BASALT && (this.suffix.isEmpty() || this.suffix.equals("smooth"))) {
            if (this.suffix.isEmpty()) {
                both = prov.existing("minecraft", "block/basalt");
                topTexture = bottomTexture = new Texture("block/basalt_top");
                sideTexture = new Texture("block/basalt_side");
            } else {
                both = prov.existing("minecraft", "block/smooth_basalt");
                bottomTexture = sideTexture = new Texture("block/smooth_basalt");
                topTexture = sideTexture;
            }
        }
        AntimatterBlockModelBuilder top = (AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)prov.models().getBuilder(this.getId() + "_top")).parent(prov.existing("minecraft", "block/slab_top"))).texture("bottom", bottomTexture)).texture("top", topTexture)).texture("side", sideTexture);
        AntimatterBlockModelBuilder bottom = (AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)((AntimatterBlockModelBuilder)prov.models().getBuilder(this.getId())).parent(prov.existing("minecraft", "block/slab"))).texture("bottom", bottomTexture)).texture("top", topTexture)).texture("side", sideTexture);
        ResourceLocation finalBoth = both;
        prov.getVariantBuilder(block).forAllStates(s -> {
            if (s.m_61143_((Property)f_56353_) == SlabType.DOUBLE) {
                return new VariantBlockStateBuilder.VariantBuilder().modelFile(finalBoth);
            }
            return new VariantBlockStateBuilder.VariantBuilder().modelFile(s.m_61143_((Property)f_56353_) == SlabType.TOP ? top : bottom);
        });
    }
}

