/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.block;

import muramasa.antimatter.block.BlockBasic;
import muramasa.antimatter.ore.CobbleStoneType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.texture.Texture;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public class BlockStone
extends BlockBasic
implements ISharedAntimatterObject {
    protected StoneType type;
    protected String suffix;

    public BlockStone(StoneType type) {
        super(type.getDomain(), type.getId(), BlockStone.getProps(type));
        this.type = type;
        this.suffix = "";
    }

    public BlockStone(StoneType type, String suffix) {
        super(type.getDomain(), type.getId() + "_" + suffix, BlockStone.getProps(type));
        this.type = type;
        this.suffix = suffix;
    }

    private static BlockBehaviour.Properties getProps(StoneType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)type.getBlockMaterial()).m_60918_(type.getSoundType()).m_60913_(type.getHardness(), type.getResistence());
        if (type.doesRequireTool()) {
            props.m_60999_();
        }
        return props;
    }

    public StoneType getType() {
        return this.type;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public Texture[] getTextures() {
        StoneType stoneType = this.type;
        if (stoneType instanceof CobbleStoneType) {
            CobbleStoneType c = (CobbleStoneType)stoneType;
            if (!this.suffix.isEmpty()) {
                return new Texture[]{new Texture(this.type.getDomain(), c.getBeginningPath() + this.type.getId() + "/" + this.suffix)};
            }
        }
        return this.type.getTextures();
    }
}

